---
name: zyla-api-hub-skill
description: Zyla API Hub Skill — Turn your OpenClaw AI agent into a real-world operator. Power it with 10,000+ production-ready APIs from Zyla API Hub — instant access to weather, finance, translation, email validation, geolocation, and more.
metadata: {"openclaw":{"requires":{},"primaryEnv":"ZYLA_API_KEY","homepage":"https://zylalabs.com/openclaw/connect"}}
---

# Zyla API Hub Skill

Turn your OpenClaw AI agent into a real-world operator.
Power it with 10,000+ production-ready APIs from Zyla API Hub — instant access to weather, finance, translation, email validation, geolocation, and more, all through one unified API key, pay-as-you-go pricing, and zero vendor lock-in.

## Setup

If `ZYLA_API_KEY` is not configured, guide the user:

1. Visit https://zylalabs.com/openclaw/connect to get an API key
2. Or run `/zyla connect` if the plugin is installed (opens browser automatically)
3. Add the key to `~/.openclaw/openclaw.json` under `skills.entries.zyla-api-hub-skill.apiKey`

Never ask the user to paste their API key in chat. Ask them to set it via the config and confirm when ready.

## Quick Start — Popular APIs

Use these directly without searching the catalog. Each includes the API ID, endpoint details, and parameters.

<!-- POPULAR_APIS_START -->
<!-- This section is auto-generated by: npx tsx scripts/generate-popular.ts -->
<!-- Run before publishing to update with the latest top 20 APIs by popularity -->

### Weather by Zip API (ID: 781)
- **Use when**: user asks about weather, temperature, forecast, climate, conditions by zip code
- **Category**: Weather & Environment
- **Call**: `npx tsx {baseDir}/scripts/zyla-api.ts call --api 781 --endpoint <endpoint_id> --params '{"zip":"10001"}'`

### Currency Conversion API (example)
- **Use when**: user asks about currency exchange, conversion rates, forex
- **Category**: Finance
- **Call**: `npx tsx {baseDir}/scripts/zyla-api.ts call --api <id> --endpoint <endpoint_id> --params '{"from":"USD","to":"EUR","amount":"100"}'`

### Email Validation API (example)
- **Use when**: user asks to validate, verify, or check an email address
- **Category**: Data Validation
- **Call**: `npx tsx {baseDir}/scripts/zyla-api.ts call --api <id> --endpoint <endpoint_id> --params '{"email":"test@example.com"}'`

> **Note**: Run `npx tsx {baseDir}/scripts/generate-popular.ts` to regenerate this section with real API IDs and endpoints from the live catalog.

<!-- POPULAR_APIS_END -->

## Discovering APIs

For APIs not listed above, search the catalog:

```bash
# Search by keyword
npx tsx {baseDir}/scripts/zyla-catalog.ts search "recipe"

# List APIs by category
npx tsx {baseDir}/scripts/zyla-catalog.ts list --category "Finance"

# Get endpoints for a specific API
npx tsx {baseDir}/scripts/zyla-catalog.ts endpoints --api 781
```

## Calling APIs

### Using the helper script (recommended)

```bash
# Basic call
npx tsx {baseDir}/scripts/zyla-api.ts call \
  --api <api_id> \
  --endpoint <endpoint_id> \
  --params '{"key":"value"}'

# Specify HTTP method (default: GET)
npx tsx {baseDir}/scripts/zyla-api.ts call \
  --api <api_id> \
  --endpoint <endpoint_id> \
  --method POST \
  --params '{"key":"value"}'

# Get info about an API
npx tsx {baseDir}/scripts/zyla-api.ts info --api <api_id>

# Check health and remaining quota
npx tsx {baseDir}/scripts/zyla-api.ts health
```

### Using curl (fallback)

```bash
curl -H "Authorization: Bearer $ZYLA_API_KEY" \
  "https://zylalabs.com/api/{api_id}/{api_slug}/{endpoint_id}/{endpoint_slug}?param=value"
```

**URL pattern**: `https://zylalabs.com/api/{api_id}/{api_name_slug}/{endpoint_id}/{endpoint_name_slug}`

- `api_id` and `endpoint_id` are numeric IDs (these do the actual routing)
- `api_name_slug` and `endpoint_name_slug` are URL-friendly names (for readability)

## Error Handling

- **401 Unauthorized**: API key is invalid or expired. Ask the user to run `/zyla connect` or visit https://zylalabs.com/openclaw/connect to get a new key.
- **403 Forbidden**: Subscription issue. The pay-as-you-go plan should handle this automatically. If it persists, ask the user to contact support.
- **429 Too Many Requests**: Rate limit exceeded. Check the `X-Zyla-RateLimit-Minute-Remaining` response header. Wait before retrying.
- **404 Not Found**: The API or endpoint does not exist. Verify the IDs using the catalog.
- **5xx Server Error**: Upstream API issue. Retry after a short delay (2-5 seconds).

## Rate Limit Headers

Every API response includes these headers:
- `X-Zyla-RateLimit-Minute-Limit`: Max requests per minute
- `X-Zyla-RateLimit-Minute-Remaining`: Remaining requests this minute
- `X-Zyla-API-Calls-Monthly-Used`: Total calls this billing cycle
- `X-Zyla-API-Calls-Monthly-Remaining`: Remaining calls this cycle

## Billing

- **Pay-as-you-go**: No monthly fee. Each API call is billed at the API's per-call rate.
- Billing happens at the end of each cycle via Stripe.
- Use the health endpoint to check current usage: `npx tsx {baseDir}/scripts/zyla-api.ts health`
