---
name: quick-review
description: 审查近期代码变更，检查 bug、安全隐患并提出改进建议。针对 git diff 中的暂存或未暂存更改提供可操作的反馈。
tags:
  - code-review
  - quality
  - security
user_invocable: true
---

# 快速代码审查

审查当前代码变更，提供简洁、可操作的反馈。

## 步骤

1. 执行 `git diff --staged` 获取暂存区的变更。如果为空，回退到 `git diff` 获取未暂存的变更。如果两者都为空，告知用户没有可审查的变更。

2. 按以下分类分析 diff：

   **Bug 与逻辑错误**
   - 边界错误、空值访问、竞态条件
   - 布尔逻辑错误或遗漏的边界情况
   - 资源泄漏（未关闭的句柄、缺失的清理逻辑）

   **安全问题**
   - 注入漏洞（SQL、XSS、命令注入）
   - 硬编码的密钥或凭证
   - 不安全的反序列化或输入处理

   **性能问题**
   - 热路径中不必要的内存分配
   - N+1 查询或缺失的索引
   - 异步上下文中的阻塞调用

   **代码质量**
   - 死代码或不可达分支
   - 应该复用的重复逻辑
   - 具有误导性的命名或不清晰的意图

3. 按文件分组展示发现的问题，格式如下：

   ### `path/to/file.ext`
   - **[Bug]** 第 42 行：问题描述及修复建议
   - **[安全]** 第 78 行：问题描述及修复建议

4. 最后用一句话总结：发现的问题总数，以及这些变更是否可以安全提交。

## 准则

- 只标记真实问题，不要挑剔代码风格、格式或提出不必要的建议。
- 要具体——引用 diff 中的确切行号和变量名。
- 如果变更没有问题，简要说明即可，不要凭空制造问题。
- 保持审查简洁，重质量不重数量。
