---
name: zotero-cli
version: 1.0.0
description: Command-line interface for Zotero - search your Zotero library, add/edit notes, read attachments, and manage bibliographic references from the terminal.
homepage: https://github.com/jbaiter/zotero-cli
metadata:
  {
    "openclaw":
      {
        "emoji": "📚",
        "requires": { "bins": ["python3"], "anyBins": ["zotcli", "zotero-cli"] },
        "install":
          [
            {
              "id": "pip",
              "kind": "pip",
              "package": "zotero-cli",
              "label": "Install zotero-cli Python package (pip)",
            },
            {
              "id": "pipx",
              "kind": "pipx",
              "package": "zotero-cli",
              "label": "Install zotero-cli Python package (pipx - recommended for systems with PEP 668 compliance)",
              "platforms": ["linux-debian", "linux-ubuntu", "linux-arch", "linux-fedora", "linux-rhel"],
            },
          ],
      },
  }
---

# Zotero CLI

Command-line interface for the Zotero reference manager, providing terminal-based access to your Zotero library through the Zotero API.

## Quick Start

```bash
# Install (PEP 668 systems)
sudo apt install pipx && pipx ensurepath && pipx install zotero-cli

# Configure
zotcli configure

# Start using
zotcli query "machine learning"
zotcli add-note "\"deep learning\""
zotcli read "\"attention mechanism\""
```

📖 **Detailed guide:** [QUICKSTART.md](QUICKSTART.md)

## Installation

### pipx (Recommended for PEP 668 systems)
```bash
pipx install zotero-cli
```

### pip (Generic)
```bash
pip install --user zotero-cli
export PATH="$HOME/.local/bin:$PATH"
```

### Virtual Environment
```bash
python3 -m venv ~/.venvs/zotero-cli
source ~/.venvs/zotero-cli/bin/activate
pip install zotero-cli
```

📖 **Complete installation guide:** [INSTALL.md](INSTALL.md)

## Core Commands

| Command | Description |
|---------|-------------|
| `zotcli query "topic"` | Search library |
| `zotcli add-note "paper"` | Add a note |
| `zotcli edit-note "paper"` | Edit a note |
| `zotcli read "paper"` | Read first PDF attachment |
| `zotcli configure` | Configure API credentials |

## Configuration

```bash
# Set default editor
export VISUAL=nano  # or vim, emacs, code

# Run configuration
zotcli configure

# Verify setup
./scripts/setup_and_check.sh
```

## Helper Scripts

| Script | Purpose |
|--------|---------|
| `setup_and_check.sh` | Automated setup and verification |
| `backup_restore.sh` | Backup and restore configuration |
| `update_check.sh` | Check for updates |
| `quick_search.py` | Formatted search output |
| `export_citations.py` | Export citations (BibTeX, RIS) |
| `batch_process.sh` | Process multiple queries |

**Usage examples:**

```bash
# Quick search
python scripts/quick_search.py "topic" --format table

# Export citations
python scripts/export_citations.py "topic" --format bib > refs.bib

# Backup
./scripts/backup_restore.sh backup

# Update check
./scripts/update_check.sh check
```

📖 **Scripts documentation:** [scripts/README.md](scripts/README.md)

## Query Syntax

```bash
"neural AND networks"        # Boolean AND
"(deep OR machine) AND learning"  # OR + grouping
"learning NOT neural"        # NOT
"\"deep learning\""          # Phrase search
"transform*"                 # Prefix search
```

## Workflows

### Literature Review
```bash
zotcli query "topic"
zotcli add-note "paper"
python scripts/export_citations.py "topic" --format bib > refs.bib
```

### Daily Research
```bash
python scripts/quick_search.py "\"recent\"" --format table
zotcli add-note "\"interesting paper\""
./scripts/backup_restore.sh backup
```

📖 **More examples:** [EXAMPLES.md](EXAMPLES.md)

## Documentation

| Document | Description |
|----------|-------------|
| [QUICKSTART.md](QUICKSTART.md) | 5-minute quick start guide |
| [INSTALL.md](INSTALL.md) | Comprehensive installation guide |
| [EXAMPLES.md](EXAMPLES.md) | Practical usage examples |
| [scripts/README.md](scripts/README.md) | Helper scripts guide |

## Troubleshooting

**Command not found:**
```bash
export PATH="$HOME/.local/bin:$PATH"
pipx ensurepath
```

**Permission denied (PEP 668 systems):**
```bash
pipx install zotero-cli
```

**Configuration errors:**
```bash
zotcli configure
```

📖 **Detailed troubleshooting:** [INSTALL.md](INSTALL.md)

## Quick Reference

```bash
# Essential commands
zotcli query "topic"              # Search
zotcli add-note "paper"           # Add note
zotcli edit-note "paper"          # Edit note
zotcli read "paper"               # Read PDF

# Helper scripts
./scripts/setup_and_check.sh      # Setup
./scripts/backup_restore.sh backup # Backup
./scripts/update_check.sh check   # Update
./scripts/batch_process.sh queries.txt --output results.txt  # Batch
```

---

**For complete documentation:**
- [QUICKSTART.md](QUICKSTART.md) - Get started
- [INSTALL.md](INSTALL.md) - Installation details
- [EXAMPLES.md](EXAMPLES.md) - Usage examples
- [SKILL_SUMMARY.md](SKILL_SUMMARY.md) - Full overview
