# Pricing Strategy — Zillow

## For Sellers

### Competitive Analysis Steps
1. Pull recently SOLD homes (not active/pending) within 0.5 miles
2. Filter by similar: beds, baths, sqft (±15%), lot size
3. Note sold price AND days on market
4. Adjust for condition differences (updated kitchen = +$X)
5. Look at currently ACTIVE competitors — you're competing with them

### Pricing Psychology

| Strategy | When to Use |
|----------|-------------|
| At market | Standard — aim for quick sale at fair value |
| 5% under market | Want multiple offers, bidding war |
| 10% over market | Unique property, testing the market |
| Make Me Move | Not actively selling, opportunistic only |

### The Overpricing Trap
1. List 10% high → no showings
2. Sit 30+ days → listing goes "stale"
3. Reduce price → signals desperation
4. Sell for LESS than if priced right initially

**Rule:** Better to price right and get multiple offers than overprice and chase the market down.

### Timing Considerations
- Check DOM trends: if inventory rising, price sharper
- Seasonal patterns matter (spring ≠ winter)
- Interest rate spikes reduce buyer pools
- New competing listings = consider waiting or adjusting

## For Buyers

### Offer Strategy by Market

| Market Type | How to Identify | Offer Strategy |
|-------------|-----------------|----------------|
| Hot seller's | DOM <14, multiple offers common | At/above ask, minimize contingencies |
| Balanced | DOM 30-60, some negotiation | At ask, standard contingencies |
| Buyer's | DOM >60, price cuts common | 5-10% under, full contingencies |

### Zestimate vs Offer Price
- Don't anchor to Zestimate — it's an algorithm, not an appraisal
- Pull actual comps: what did similar homes SELL for?
- In hot markets, Zestimate often LAGS actual values
- In slow markets, Zestimate may be ABOVE actual values

### What Affects Your Offer Strength

| Factor | Impact |
|--------|--------|
| Cash vs financed | Cash wins, always |
| Down payment size | 20%+ beats 3.5% FHA |
| Contingencies | Fewer = stronger (but riskier) |
| Close timeline | Flexible = attractive to sellers |
| Pre-approval vs pre-qual | Pre-approval is mandatory |
| Earnest money | Larger deposit = more serious |
