# Investment Analysis — Zillow

## Core Metrics

| Metric | Formula | Target |
|--------|---------|--------|
| Cap Rate | (Gross Rent - Expenses) / Purchase Price | >6% typical |
| Cash-on-Cash | Annual Cash Flow / Total Cash Invested | >8% desirable |
| GRM | Purchase Price / Annual Gross Rent | <10 is good |
| 1% Rule | Monthly Rent ≥ 1% of Purchase Price | Quick screen |
| DSCR | NOI / Annual Debt Service | >1.25 for loans |

## Expense Estimation

The 50% rule is a starting point, not gospel. Actual breakdown:

| Category | Typical % of Gross Rent |
|----------|------------------------|
| Property taxes | 8-15% (varies wildly) |
| Insurance | 5-10% |
| Vacancy | 5-15% |
| Maintenance | 8-12% |
| CapEx reserves | 5-10% |
| Property management | 8-12% |
| Utilities (if paid) | 0-10% |

## What Zillow Gets Wrong

**Rent Zestimates:**
- Often 10-20% off actual achievable rent
- Doesn't account for property condition
- Ignores Section 8/voucher market dynamics
- Misses seasonal fluctuations (college towns)

**Purchase Price Assumptions:**
- Use realistic acquisition cost, not list price
- Factor in closing costs (2-5%)
- Include rehab budget if needed
- Account for negotiation in your market

## Market Quality Checklist

Before trusting high cap rates, verify:
- [ ] Population trend (growing = good)
- [ ] Job market stability
- [ ] Crime statistics by neighborhood
- [ ] Landlord-tenant law friendliness (eviction timelines)
- [ ] Rent control/stabilization laws
- [ ] Property tax trajectory

## Negative Leverage Warning

If cap rate < mortgage rate, you have negative leverage:
- 7% cap rate with 8% interest = losing money on borrowed portion
- Cash deals and financed deals require different analysis
- Always calculate BOTH scenarios
