/**
 * Demo data — Austin TX 78704 (SoCo district)
 * Realistic Austin TX market data (78704 = South Congress / SoCo - hot STR market)
 * These numbers reflect actual Austin STR market conditions as of 2025
 */

const DEMO_ZILLOW_LISTINGS = [
  {
    zpid: "88291847",
    address: "1847 South Congress Ave Unit 3",
    city: "Austin",
    state: "TX",
    zip: "78704",
    price: 485000,
    beds: 2,
    baths: 2,
    sqft: 1150,
    yearBuilt: 2018,
    propertyType: "Condo",
    daysOnMarket: 12,
    zestimate: 491000,
    listingUrl: "https://zillow.com/homes/88291847_zpid",
    lat: 30.2411,
    lng: -97.7492,
    pricePerSqft: 422
  },
  {
    zpid: "88305512",
    address: "2203 Barton Springs Road",
    city: "Austin",
    state: "TX",
    zip: "78704",
    price: 725000,
    beds: 3,
    baths: 2,
    sqft: 1680,
    yearBuilt: 1962,
    propertyType: "Single Family",
    daysOnMarket: 7,
    zestimate: 738000,
    listingUrl: "https://zillow.com/homes/88305512_zpid",
    lat: 30.2619,
    lng: -97.7701,
    pricePerSqft: 431
  },
  {
    zpid: "88317209",
    address: "912 West Annie Street",
    city: "Austin",
    state: "TX",
    zip: "78704",
    price: 599000,
    beds: 2,
    baths: 1,
    sqft: 980,
    yearBuilt: 1948,
    propertyType: "Single Family",
    daysOnMarket: 21,
    zestimate: 610000,
    listingUrl: "https://zillow.com/homes/88317209_zpid",
    lat: 30.2498,
    lng: -97.7581,
    pricePerSqft: 611
  },
  {
    zpid: "88329841",
    address: "3401 South Lamar Blvd Apt 108",
    city: "Austin",
    state: "TX",
    zip: "78704",
    price: 375000,
    beds: 1,
    baths: 1,
    sqft: 720,
    yearBuilt: 2021,
    propertyType: "Condo",
    daysOnMarket: 34,
    zestimate: 368000,
    listingUrl: "https://zillow.com/homes/88329841_zpid",
    lat: 30.2362,
    lng: -97.7823,
    pricePerSqft: 521
  },
  {
    zpid: "88341003",
    address: "704 East Monroe Street",
    city: "Austin",
    state: "TX",
    zip: "78704",
    price: 850000,
    beds: 4,
    baths: 3,
    sqft: 2200,
    yearBuilt: 1935,
    propertyType: "Single Family",
    daysOnMarket: 5,
    zestimate: 862000,
    listingUrl: "https://zillow.com/homes/88341003_zpid",
    lat: 30.2511,
    lng: -97.7452,
    pricePerSqft: 386
  },
  {
    zpid: "88352714",
    address: "1501 Kinney Avenue",
    city: "Austin",
    state: "TX",
    zip: "78704",
    price: 1150000,
    beds: 4,
    baths: 3.5,
    sqft: 2750,
    yearBuilt: 2019,
    propertyType: "Single Family",
    daysOnMarket: 18,
    zestimate: 1165000,
    listingUrl: "https://zillow.com/homes/88352714_zpid",
    lat: 30.2561,
    lng: -97.7612,
    pricePerSqft: 418
  },
  {
    zpid: "88364228",
    address: "2089 Govalle Avenue",
    city: "Austin",
    state: "TX",
    zip: "78702",
    price: 410000,
    beds: 2,
    baths: 1,
    sqft: 890,
    yearBuilt: 1955,
    propertyType: "Single Family",
    daysOnMarket: 44,
    zestimate: 405000,
    listingUrl: "https://zillow.com/homes/88364228_zpid",
    lat: 30.2612,
    lng: -97.7101,
    pricePerSqft: 461
  }
];

const DEMO_AIRBNB_LISTINGS = [
  {
    id: "airbnb-912291847",
    address: "1847 S Congress Ave, Unit 3",  // matches Zillow #1 (S vs South)
    city: "Austin",
    state: "TX",
    zip: "78704",
    title: "Stylish SoCo Condo - Walk to Everything",
    beds: 2,
    baths: 2,
    maxGuests: 4,
    nightly_rate: 189,
    monthly_revenue_avg: 4820,
    annual_revenue_est: 57840,
    occupancy_rate: 0.84,
    total_reviews: 147,
    avg_rating: 4.91,
    host_status: "Superhost",
    active_months: 18,
    airbnbUrl: "https://airbnb.com/rooms/912291847",
    lat: 30.2411,
    lng: -97.7492,
    peak_season: "Mar-May, Sep-Nov",
    lowest_month_revenue: 3200,
    highest_month_revenue: 6800
  },
  {
    id: "airbnb-783051122",
    address: "2203 Barton Springs Rd",  // matches Zillow #2 (Road vs Rd)
    city: "Austin",
    state: "TX",
    zip: "78704",
    title: "Zilker Gem - 3BR Near Barton Springs Pool",
    beds: 3,
    baths: 2,
    maxGuests: 6,
    nightly_rate: 295,
    monthly_revenue_avg: 7210,
    annual_revenue_est: 86520,
    occupancy_rate: 0.81,
    total_reviews: 89,
    avg_rating: 4.87,
    host_status: "Superhost",
    active_months: 11,
    airbnbUrl: "https://airbnb.com/rooms/783051122",
    lat: 30.2619,
    lng: -97.7701,
    peak_season: "Mar-May, Oct-Nov",
    lowest_month_revenue: 4800,
    highest_month_revenue: 9500
  },
  {
    id: "airbnb-901172091",
    address: "912 W Annie St",  // matches Zillow #3 (W vs West)
    city: "Austin",
    state: "TX",
    zip: "78704",
    title: "Bungalow Dream in the Heart of Travis Heights",
    beds: 2,
    baths: 1,
    maxGuests: 4,
    nightly_rate: 225,
    monthly_revenue_avg: 5940,
    annual_revenue_est: 71280,
    occupancy_rate: 0.88,
    total_reviews: 231,
    avg_rating: 4.95,
    host_status: "Superhost",
    active_months: 24,
    airbnbUrl: "https://airbnb.com/rooms/901172091",
    lat: 30.2498,
    lng: -97.7581,
    peak_season: "SXSW (Mar), ACL (Oct)",
    lowest_month_revenue: 3900,
    highest_month_revenue: 8200
  },
  {
    id: "airbnb-822984411",
    address: "3401 S Lamar Blvd #108",  // matches Zillow #4
    city: "Austin",
    state: "TX",
    zip: "78704",
    title: "Modern 1BR on South Lamar - Perfect Location",
    beds: 1,
    baths: 1,
    maxGuests: 2,
    nightly_rate: 155,
    monthly_revenue_avg: 3890,
    annual_revenue_est: 46680,
    occupancy_rate: 0.83,
    total_reviews: 64,
    avg_rating: 4.82,
    host_status: "Regular",
    active_months: 8,
    airbnbUrl: "https://airbnb.com/rooms/822984411",
    lat: 30.2362,
    lng: -97.7823,
    peak_season: "Mar, Oct",
    lowest_month_revenue: 2800,
    highest_month_revenue: 5100
  },
  {
    id: "airbnb-981112293",
    address: "704 E Monroe St",  // matches Zillow #5 (E vs East)
    city: "Austin",
    state: "TX",
    zip: "78704",
    title: "Historic 4BR Craftsman - Entire House, Prime SoCo",
    beds: 4,
    baths: 3,
    maxGuests: 8,
    nightly_rate: 420,
    monthly_revenue_avg: 10850,
    annual_revenue_est: 130200,
    occupancy_rate: 0.86,
    total_reviews: 178,
    avg_rating: 4.93,
    host_status: "Superhost",
    active_months: 20,
    airbnbUrl: "https://airbnb.com/rooms/981112293",
    lat: 30.2511,
    lng: -97.7452,
    peak_season: "SXSW, F1, ACL",
    lowest_month_revenue: 7200,
    highest_month_revenue: 14500
  },
  // Airbnb listing with NO Zillow match (already rented, not for sale)
  {
    id: "airbnb-741938822",
    address: "623 Bouldin Avenue",
    city: "Austin",
    state: "TX",
    zip: "78704",
    title: "Bouldin Creek Cottage - Superhost",
    beds: 2,
    baths: 1,
    maxGuests: 4,
    nightly_rate: 199,
    monthly_revenue_avg: 5100,
    annual_revenue_est: 61200,
    occupancy_rate: 0.85,
    total_reviews: 312,
    avg_rating: 4.97,
    host_status: "Superhost",
    active_months: 36,
    airbnbUrl: "https://airbnb.com/rooms/741938822",
    lat: 30.2488,
    lng: -97.7560
  }
];

const DEMO_COMMERCIAL_ZILLOW = [
  {
    zpid: "C-44812001",
    address: "2800 East 12th Street",
    city: "Austin",
    state: "TX",
    zip: "78702",
    price: 2800000,
    sqft: 8500,
    propertyType: "Mixed Use",
    capRate: null,
    daysOnMarket: 28,
    source: "Crexi",
    listingUrl: "https://crexi.com/properties/44812001",
    zoning: "CS-MU",
    units: 6,
    yearBuilt: 1978
  },
  {
    zpid: "C-44819882",
    address: "1406 South Congress Ave",
    city: "Austin",
    state: "TX",
    zip: "78704",
    price: 4200000,
    sqft: 11200,
    propertyType: "Retail/Office",
    capRate: 5.8,
    daysOnMarket: 15,
    source: "LoopNet",
    listingUrl: "https://loopnet.com/listing/44819882",
    zoning: "CS",
    units: null,
    yearBuilt: 2001
  }
];

module.exports = {
  DEMO_ZILLOW_LISTINGS,
  DEMO_AIRBNB_LISTINGS,
  DEMO_COMMERCIAL_ZILLOW
};
