# 周易·八字核心典籍速查

> 面向回答八字、子平命理、奇门等问题时快速定位原典背景、理论重点与适用场景。引用时保留书名与朝代，并在需要时补充下列要点。

## 四大经典（理法 + 格局基石）

### 《渊海子平》（宋·徐大升据徐子平命法编）
- **定位**：首部系统论述四柱命理的合集，确立“以日干为身主”的子平体系，被视为后世子平法源头。内容跨基础理论与歌赋口诀，保留五卷原貌。  
- **结构亮点**：卷一铺陈五行、天干地支、纳音与神煞；卷二详解正官、七杀、格局入式；卷三着重六亲与性情、女命、小儿；卷四、五收大量赋文与诗诀，方便查歌决源。  
- **使用场景**：需要引用传统术语定义、古法格局歌诀、六亲描写或节气调候歌时先查此书。  
- **慎用提醒**：卷中观点杂糅多家，必要时说明出典属于古法歌诀而非当代实务标准。  
- **来源**：Baidu Baike — 渊海子平 (https://baike.baidu.com/item/%E6%B8%8A%E6%B5%B7%E5%AD%90%E5%B9%B3/6456620)

### 《三命通会》（明·万民英）
- **定位**：命理百科式总集，十二卷兼容子平、纳音、神煞、歌赋，被清《四库全书》誉为“谈星命者总彙”。  
- **结构亮点**：前九卷按十天干立论“以日主、月令为纲”，后三卷集结赋文与案例；常用于交叉验证官印财禄、用神轻重与神煞含义。  
- **使用场景**：当问题需要大范围比较各家格局、引用历代命例或解释神煞体系时引用本书。  
- **慎用提醒**：书中偏重正官正印，部分论断对偏神着墨不足，回答时可指出这一历史局限。  
- **来源**：Baidu Baike — 三命通会 (https://baike.baidu.com/item/%E4%B8%89%E5%91%BD%E9%80%9A%E4%BC%9A/360415)

### 《滴天髓》（相传宋京图著，清·任铁樵《滴天髓阐微》注）
- **定位**：重"理气"的命理哲学文本，被后世称为“命学圣经”；任铁樵、徐乐吾等注家以实盘印证其“阴阳成象”“气机流行”思想。  
- **结构亮点**：分《通神论》《六亲论》，34 章逐一讨论天道、地道、体用、寒暖燥湿等抽象命理命题。  
- **使用场景**：需要解释“气机流通”“扶抑调候”“刚柔中和”等原理、或阐述理法高层思路时引用。  
- **慎用提醒**：避免把书中“理气”直接等同现代日主强弱评分；回答时说明其强调顺应气势的思想背景。  
- **来源**：Baidu Baike — 滴天髓 (https://baike.baidu.com/item/%E6%BB%B4%E5%A4%A9%E9%AB%93/6165128)

### 《子平真诠》（清·沈孝瞻）
- **定位**：子平格局体系的逻辑化总结，48 章以“用神—相神—格局—行运”串联，被视为学格局法的入门钥匙。  
- **结构亮点**：前七章讲五行旺衰与十神；中段详述取用、格局高低、相神辅佐；末段讨论行运、六亲与十神吉凶。  
- **使用场景**：需要解释格局成败、月令提纲、取用神步骤或现代格局法基准时引用。  
- **慎用提醒**：书内论述聚焦“富贵层级”，回答现代生活议题时需额外翻译成可执行建议。  
- **来源**：Baidu Baike — 子平真诠 (https://baike.baidu.com/item/%E5%AD%90%E5%B9%B3%E7%9C%9F%E8%AF%A0/6455635)

## 关键补充典籍

| 典籍 | 核心要义 | 推荐用途 | 来源 |
| --- | --- | --- | --- |
| 《穷通宝鉴》（清·余春台增订） | 以月令气候为纲、主张“调候先行”，逐一讨论十天干在十二月的喜忌、寒暖燥湿补救。 | 解释调候用神、季节气候与五行失衡关系；或需要列举“某干某月宜先取水火”时。 | Baidu Baike — 穷通宝鉴 (https://baike.baidu.com/item/%E7%A9%B7%E9%80%9A%E5%AE%9D%E9%89%B4/360938) |
| 《神峰通考》（明·张楠） | 汇整四十余年子平实务，提出动静说、病药说、雕枯旺弱八法，并直白注释诸多古歌赋。 | 当问题需要“病药”视角（找出命局病、选药）或引述六亲、宫位系统化内容时。 | Baidu Baike — 神峰通考 (https://baike.baidu.com/item/%E7%A5%9E%E5%B3%B0%E9%80%9A%E8%80%83/6458975) |
| 《命理约言》（清·陈素庵，民国·韦千里校） | 四卷分“法—赋—论—杂论”，强调命理分析需同时兼顾月令寒暖与日主强弱，并系统回答“怎么看格、运、六亲”。 | 用作“标准化流程”引用，引导读者先判格局、再谈运势、再落位六亲。 | Baidu Baike — 命理约言 (https://baike.baidu.com/item/%E5%91%BD%E7%90%86%E7%BA%A6%E8%A8%80/792508) |
| 《星平会海》（明代命师“水中龙”编，后经清、民国续刻） | 十卷并收七政四余（五星命理）与子平命理：前五卷谈星曜、入宫歌、女命警诀；后五卷含《起八字例》《取格指诀》等。 | 当需要跨卜“星命 + 四柱”或引用女命、小儿关煞、星曜歌诀等内容时。 | Baidu Baike — 星平会海 (https://baike.baidu.com/item/%E6%98%9F%E5%B9%B3%E4%BC%9A%E6%B5%B7/1104217) |
| 《命理探源》（晚清民国·袁树珊） | 以考据+实务结合的现代化命理读本，强调命师自我修养、列出十条职业守则，并考证流年神煞、双生命等争议。 | 当用户需要现代语境、职业伦理、方法论（如“命师应具备什么素质”）时引用；也适合说明清末民国的验证思路。 | Baidu Baike — 命理探源 (https://baike.baidu.com/item/%E5%91%BD%E7%90%86%E6%8E%A2%E6%BA%90/6366249) |

## 使用策略

1. **场景对号入座**：
   - 想了解“原典定义 + 歌诀” → 先查《渊海子平》《三命通会》。
   - 想解释“理气/气机/调候” → 结合《滴天髓》《穷通宝鉴》。
   - 需要“格局与取用的硬逻辑” → 以《子平真诠》《命理约言》为准绳。
   - 需要“诊断病药 + 六亲演绎” → 调用《神峰通考》内容。
   - 跨三星（七政四余）或引用近代命师职业准则 → 查看《星平会海》《命理探源》。

2. **引用方式**：陈述核心观点时给出“《书名》+章节/卷别（如有）+总结”，并在答案末尾列出来源链接或书名说明。

3. **翻译现代语境**：多数典籍以“富贵/贫贱”评判，可在回答中主动转换成“职业发展、资源分配、健康管理”等现代术语，避免直接断凶吉。

4. **结合用户提问层级**：
   - 入门科普：优先引用结构清晰的《子平真诠》《命理约言》。
   - 深度研究：可追加《滴天髓》《神峰通考》原文，并说明出处译意。
   - 实操演算：若需演示排盘/调候流程，补充现代工具（如电脑排盘）以承接古法概念。

5. **版权与可见性**：上述资料均来自公开百科或高清影印介绍，回答时引用摘要或自写笔记，避免大段复制古籍全文。
