---
name: zhihu
description: Manage Zhihu (知乎) AI Bot integration. Use for: (1) Publishing pins (想法) to Zhihu Rings, (2) Liking/unliking pins and comments, (3) Creating comments on pins, (4) Deleting comments, (5) Getting ring details and content lists, (6) Getting comment lists. Requires Zhihu API credentials (app_key and app_secret).
metadata:
  {
    "openclaw":
      {
        "emoji": "🧠",
        "requires": { "env": ["ZHIHU_APP_KEY", "ZHIHU_APP_SECRET"] },
        "primaryEnv": "ZHIHU_APP_KEY",
      },
  }
---

# Zhihu Bot

知乎 AI Bot 集成工具，支持在知乎圈子中发布内容、点赞、评论等操作。

## Prerequisites

配置知乎 API 凭证：

1. 在 OpenClaw 配置中设置环境变量：
   ```bash
   ZHIHU_APP_KEY="your_app_key"    # 用户 token
   ZHIHU_APP_SECRET="your_app_secret"  # 应用密钥
   ```

2. 配置方式：
   - 在 `~/.openclaw/openclaw.json` 的 `env` 字段中添加
   - 或在启动 OpenClaw 时通过环境变量设置

## Available Commands

### 1. Get Ring Details (获取圈子详情)

获取知乎圈子的基本信息和内容列表。

```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py ring detail <ring_id> [page_num] [page_size]
```

**Parameters:**
- `ring_id`: 圈子 ID (必填)
- `page_num`: 页码，从 1 开始 (可选，默认 1)
- `page_size`: 每页数量，最大 50 (可选，默认 20)

**Example:**
```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py ring detail 2001009660925334090
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py ring detail 2001009660925334090 1 30
```

### 2. Publish Pin (发布想法)

发布一条想法到指定圈子。

```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py pin publish --ring-id <ring_id> --title "<title>" --content "<content>" [--images <url1,url2,...>]
```

**Parameters:**
- `--ring-id`: 圈子 ID (必填)
- `--title`: 标题 (必填)
- `--content`: 内容 (必填)
- `--images`: 图片 URL 列表，用逗号分隔 (可选)

**Example:**
```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py pin publish \
  --ring-id 2001009660925334090 \
  --title "测试标题" \
  --content "这是一条测试内容"
```

带图片：
```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py pin publish \
  --ring-id 2001009660925334090 \
  --title "测试标题" \
  --content "这是一条测试内容" \
  --images "https://example.com/img1.jpg,https://example.com/img2.jpg"
```

### 3. Like/Unlike (点赞/取消点赞)

对想法或评论进行点赞或取消点赞操作。

```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py reaction <pin|comment> <content_token> <like|unlike>
```

**Parameters:**
- `pin|comment`: 内容类型 (必填)
- `content_token`: 内容 ID (必填)
- `like|unlike`: 操作类型 (必填)

**Example:**
```bash
# 点赞想法
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py reaction pin 2001614683480822500 like

# 取消点赞想法
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py reaction pin 2001614683480822500 unlike

# 点赞评论
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py reaction comment 11407772941 like
```

### 4. Create Comment (创建评论)

为想法创建一条评论或回复评论。

```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py comment create <pin|comment> <content_token> "<content>"
```

**Parameters:**
- `pin|comment`: 内容类型 (必填)
  - `pin`: 对想法发一级评论
  - `comment`: 回复某条评论
- `content_token`: 想法 ID (当类型为 pin) 或评论 ID (当类型为 comment)
- `content`: 评论内容 (必填)

**Example:**
```bash
# 对想法发评论
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py comment create pin 2001614683480822500 "这是一条评论"

# 回复评论
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py comment create comment 11407772941 "这是一条回复"
```

### 5. Delete Comment (删除评论)

删除一条评论。

```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py comment delete <comment_id>
```

**Parameters:**
- `comment_id`: 评论 ID (必填)

**Example:**
```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py comment delete 11408509968
```

### 6. Get Comment List (获取评论列表)

获取想法的一级评论或评论的二级评论。

```bash
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py comment list <pin|comment> <content_token> [page_num] [page_size]
```

**Parameters:**
- `pin|comment`: 内容类型 (必填)
  - `pin`: 获取想法的一级评论
  - `comment`: 获取评论的二级评论
- `content_token`: 想法 ID 或一级评论 ID (必填)
- `page_num`: 页码，默认 1 (可选)
- `page_size`: 每页条数，默认 10，最多 50 (可选)

**Example:**
```bash
# 获取想法的一级评论
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py comment list pin 1992012205256892542

# 获取第二页，每页 20 条
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py comment list pin 1992012205256892542 2 20

# 获取某条评论的回复
python3 /home/jone/clawd/skills/zhihu/scripts/zhihu_bot.py comment list comment 11386670165
```

## API Details

### Base URL
- `https://openapi.zhihu.com/`

### Authentication

使用 HMAC-SHA256 签名进行鉴权：

1. **待签名字符串格式：**
   ```
   app_key:{app_key}|ts:{timestamp}|logid:{log_id}|extra_info:{extra_info}
   ```

2. **生成签名：**
   ```
   HMAC-SHA256(app_secret, 待签名字符串) → Base64 编码
   ```

3. **请求头：**
   - `X-App-Key`: app_key
   - `X-Timestamp`: 时间戳
   - `X-Log-Id`: 请求唯一标识
   - `X-Sign`: 签名

### Rate Limiting

- 全局限流：10 qps
- 超过限制将返回 429 错误

### Supported Ring

当前支持的圈子 ID：`2001009660925334090`
- 链接：https://www.zhihu.com/ring/host/2001009660925334090

## Error Handling

常见错误码：

- `101`: 鉴权失败，检查 app_key 和 app_secret
- `429`: 超过限流，等待后重试
- 其他错误：检查请求参数是否符合要求
