---
name: zhihu-hot-cn
description: 知乎热榜监控 - 获取知乎热门话题、问题和趋势分析（Quora 中国版）
metadata:
  openclaw:
    emoji: "🔥"
    category: "social"
    tags: ["zhihu", "trending", "china", "social-media"]
---

# 知乎热榜监控

获取知乎热门话题、问题和趋势分析。

## 功能

- 🔥 获取知乎实时热榜
- 📊 分析热门话题趋势
- 🏷️ 按类别筛选（科技、娱乐、财经等）
- 💾 导出为 Markdown/JSON

## 使用方法

### 获取热榜

```bash
# 获取当前热榜（前 50 条）
./scripts/get-hot.sh

# 获取指定数量
./scripts/get-hot.sh --limit 20

# 输出 JSON 格式
./scripts/get-hot.sh --format json
```

### 按类别筛选

```bash
# 科技类话题
./scripts/get-hot.sh --category tech

# 财经类话题
./scripts/get-hot.sh --category finance

# 娱乐类话题
./scripts/get-hot.sh --category entertainment
```

### 趋势分析

```bash
# 对比昨天和今天的热榜变化
./scripts/compare-trends.sh

# 查找持续热门的话题（连续 3 天在榜）
./scripts/find-persistent.sh --days 3
```

## 数据来源

知乎热榜数据来自公开数据源：
- [zhihu-hot-questions](https://github.com/towelong/zhihu-hot-questions) - 每小时更新
- [SnailDev/zhihu-hot-hub](https://github.com/SnailDev/zhihu-hot-hub) - 按天归档

## 输出示例

### Markdown 格式

```markdown
# 知乎热榜 - 2026-02-19

1. [如何评估 AI Agent 的商业价值？](https://zhihu.com/question/xxx) 🔥 999万热度
2. [2026 年最值得学习的编程语言？](https://zhihu.com/question/xxx) 💬 523 回答
3. ...
```

### JSON 格式

```json
{
  "date": "2026-02-19",
  "items": [
    {
      "rank": 1,
      "title": "如何评估 AI Agent 的商业价值？",
      "url": "https://zhihu.com/question/xxx",
      "heat": 9990000,
      "answers": 523
    }
  ]
}
```

## 热度指标

- **🔥 热度值**: 综合浏览量、互动量计算
- **💬 回答数**: 问题下的回答数量
- **⏰ 在榜时间**: 持续在热榜的天数

## 与其他平台对比

| 平台 | 对应美国平台 | 特点 |
|------|-------------|------|
| **知乎** | Quora | 问答社区，知识分享 |
| 抖音 | TikTok | 短视频 |
| 小红书 | Instagram | 图文分享 |
| B站 | YouTube | 长视频 |

## 使用场景

1. **内容创作**: 发现热门话题，获取创作灵感
2. **市场研究**: 了解用户关注点
3. **舆情监控**: 追踪品牌/产品讨论
4. **知识获取**: 快速了解当日热点

## 注意事项

- 数据来自公开数据源，非官方 API
- 热榜每小时更新一次
- 如需实时数据，请访问知乎官网

---

*版本: 1.0.0*
*数据源: GitHub 公开项目*
