# Zettelkasten - 卡片盒笔记法

一个功能完整的卡片盒笔记法系统，支持灵感捕获、AI扩展建议、关联检测和每日回顾。

## 🎯 核心功能

### 1. 灵感捕获与归纳
- 📝 自动记录用户想法，生成结构化卡片
- 🧠 AI自动生成3-5个相关标签
- 📊 自动判断笔记类型（闪念/文献/永久）
- 🚀 生成AI洞察和扩展建议

### 2. AI扩展建议
- 💡 自动生成3条相关扩展建议
- 📁 每条建议保存为独立卡片
- 🔗 记录关联关系，形成知识网络

### 3. 链接侦探
- 🔍 自动检索潜在关联的旧概念
- 🤝 发现用户想法与AI建议的联系
- 📝 支持迭代更新和扩展

### 4. 每日回顾
- 📅 每天推送随机卡片供用户回顾
- 💡 促进知识巩固和迭代

## 🚀 使用方法

### 记录灵感
```
记录灵感：我发现每天早上冥想10分钟可以提高工作效率，而且晚上睡眠质量也会更好
```

### 自动触发功能
1. 灵感捕获后自动生成AI扩展建议
2. 链接侦探自动提示潜在联系
3. 每日回顾（可定时）

## 📋 输出格式
```markdown
---
ID: 1770274826
Tags: #思考 #创意 #想法
Type: 闪念
Date: 2026-02-05
---

## 我要做一个猫语解读机器人...
我要做一个猫语解读机器人，现在初步想法是通过用户自己录制家里咪咪的叫声和记录当时的行为、情绪等可猜测的表现，在后台积累数据并通过机器学习算法逐步推断出准确的猫语含义。

> AI 洞察：这个观点涉及心理学领域，可能与习惯养成相关
```

## 📦 安装方法
```bash
clawhub install zettelkasten
```

## 🧰 技术栈
- Python 3
- OpenClaw SDK
- JSON数据存储
- NLP自然语言处理

## 📄 许可证
MIT License