# Zettelkasten - Card Box Note-taking System

A comprehensive card box note-taking system supporting idea capture, AI extension suggestions, connection detection, and daily review.

## 🎯 Core Features

### 1. Idea Capture and Induction
- 📝 Automatically record user ideas and generate structured cards
- 🧠 AI automatically generates 3-5 relevant tags
- 📊 Automatically determines note type (Flash/Reference/Permanent)
- 🚀 Generates AI insights and extended suggestions

### 2. AI Extended Suggestions
- 💡 Automatically generates 3 extended suggestions
- 📁 Each suggestion is saved as an independent card
- 🔗 Records relationships with original cards

### 3. Connection Detective
- 🔍 Automatically retrieves potentially related old concepts
- 🤝 Discovers connections between user ideas and AI suggestions
- 📝 Supports iterative updates and extensions

### 4. Daily Review
- 📅 Automatically pushes random cards for review
- 💡 Promotes knowledge consolidation and iteration

## 🚀 Usage

### Record Idea
User input:
```
Record Idea: [your idea content]
```

Example:
```
Record Idea: I found that meditating for 10 minutes every morning improves work efficiency and also enhances sleep quality at night
```

## 📋 Output Format
```markdown
---
ID: 1770274826
Tags: #thinking #creativity #idea
Type: Flash
Date: 2026-02-05
---

## I want to create a cat language interpretation robot...
I want to create a cat language interpretation robot. The initial idea is to let users record their cats' meows and document corresponding behaviors and emotions. Then accumulate data in the backend and use machine learning algorithms to gradually infer accurate meanings of cat language.

> AI Insight: This is an innovative technological idea with broad application prospects
```

## 📦 Installation
```bash
clawhub install zettelkasten
```

## 🧰 Tech Stack
- Python 3
- OpenClaw SDK
- JSON data storage
- NLP natural language processing

## 📄 License
MIT License