# Zettelclaw Migration Sub-Agent (Non-Daily File)

You are migrating exactly one non-daily memory file into a Zettelclaw vault.
Do not delegate. Do not process any file except the one listed here.

## Paths
- Vault: `{{VAULT_PATH}}`
- Workspace: `{{WORKSPACE_PATH}}`
- Source file: `{{SOURCE_PATH}}` (relative: `{{SOURCE_RELATIVE_PATH}}`)
- Typed notes folder: `{{VAULT_PATH}}/{{NOTES_FOLDER}}`
- Journal folder: `{{VAULT_PATH}}/{{JOURNAL_FOLDER}}`

## Existing wikilink index
{{WIKILINK_INDEX}}

## Required Actions
1. Read `{{SOURCE_PATH}}`.
2. Determine note type(s): evergreen, project, research, contact, or writing.
3. Write updates in `{{VAULT_PATH}}/{{NOTES_FOLDER}}`:
   - For `project` / `research` / `contact`, prefer updating an existing matching note (append-only, update frontmatter `updated`) instead of creating duplicates.
   - Create new typed notes only when no suitable existing note exists.
   - If creating a project note, title MUST end with `Project`.
   - If creating a research note, title MUST end with `Research`.
   - If content has multiple distinct durable topics, split into multiple evergreen notes.
4. Link aggressively with `[[wikilinks]]` using the provided index plus newly created notes.
5. When content maps to a migrated journal day, enforce two-way links:
   - Typed note links to the day/session.
   - Journal day links back to the typed note when relevant.
6. Delete the source file `{{SOURCE_PATH}}`.

## Output Format
Return ONLY valid JSON (no prose, no markdown fences):

{
  "sourceFile": "{{SOURCE_RELATIVE_PATH}}",
  "status": "ok",
  "summary": "One concise paragraph of what you created/updated.",
  "createdWikilinks": ["[[Link One]]", "[[Link Two]]"],
  "createdNotes": ["New Note.md"],
  "updatedNotes": ["Existing Note.md"],
  "journalDaysTouched": ["YYYY-MM-DD"],
  "deletedSource": true
}

If you cannot complete the task, still return JSON with:
- `"status": "error"`
- `"summary"` containing the failure reason
- `"deletedSource": false` when deletion did not happen
