---
name: zerodust-chain-exit
description: Sweep 100% of native gas tokens from EIP-7702 compatible chains. Leaves exactly zero balance. Supports 25 mainnet chains.
user-invocable: true
metadata: {"openclaw": {"always": false, "emoji": "🧹", "requires": {"env": ["ZERODUST_API_KEY"]}}}
---

# ZeroDust Chain Exit

ZeroDust enables sweeping native gas tokens to **exactly zero balance** using EIP-7702 sponsored execution. This only works on chains that support EIP-7702 (not all EVM chains).

## When to Use This Skill

Activate when the user wants to:
- Fully exit a blockchain (move all native tokens out)
- Sweep dust/small balances from wallets
- Transfer 100% of their balance with zero remainder
- Empty a wallet completely
- Consolidate funds from multiple chains

## Trigger Phrases

- "exit this chain completely"
- "transfer all my balance from [chain]"
- "sweep my dust"
- "empty this wallet"
- "move everything to [chain]"
- "leave zero balance"

## Supported Chains (25 EIP-7702 Compatible)

| Chain | ID | Native Token |
|-------|-----|--------------|
| Ethereum | 1 | ETH |
| BSC | 56 | BNB |
| Base | 8453 | ETH |
| Arbitrum | 42161 | ETH |
| Optimism | 10 | ETH |
| Polygon | 137 | POL |
| Gnosis | 100 | XDAI |
| Scroll | 534352 | ETH |
| Zora | 7777777 | ETH |
| Mode | 34443 | ETH |
| Mantle | 5000 | MNT |
| Celo | 42220 | CELO |
| Fraxtal | 252 | FRAX |
| Unichain | 130 | ETH |
| World Chain | 480 | ETH |
| Berachain | 80094 | BERA |
| Ink | 57073 | ETH |
| Plasma | 9745 | XPL |
| BOB | 60808 | ETH |
| Story | 1514 | IP |
| Superseed | 5330 | ETH |
| Sei | 1329 | SEI |
| Sonic | 146 | S |
| Soneium | 1868 | ETH |
| X Layer | 196 | OKB |

**Note:** Chains like Avalanche, Blast, Linea, and Apechain do NOT support EIP-7702 and cannot be swept.

## API Base URL

```
https://zerodust-backend-production.up.railway.app
```

## Step 1: Register for API Key (One-Time)

```bash
curl -X POST https://zerodust-backend-production.up.railway.app/agent/register \
  -H "Content-Type: application/json" \
  -d '{
    "name": "My OpenClaw Agent",
    "agentId": "openclaw-unique-id"
  }'
```

Response:
```json
{
  "apiKey": "zd_abc123...",
  "keyPrefix": "zd_abc12",
  "keyId": "uuid",
  "keyType": "agent",
  "rateLimits": { "perMinute": 300, "daily": 1000 },
  "message": "IMPORTANT: Save your API key now - it will not be shown again!"
}
```

Store `apiKey` as the `ZERODUST_API_KEY` environment variable.

## Step 2: Get Quote

Check the user's balance and fees before sweeping:

```bash
curl "https://zerodust-backend-production.up.railway.app/quote?userAddress=0xUSER&fromChainId=42161&toChainId=8453&destination=0xDEST"
```

Response:
```json
{
  "quoteId": "uuid",
  "fromChainId": 42161,
  "toChainId": 8453,
  "userAddress": "0x...",
  "destination": "0x...",
  "balance": "500000000000000",
  "balanceFormatted": "0.0005",
  "estimatedReceive": "485000000000000",
  "estimatedReceiveFormatted": "0.000485",
  "totalFeeWei": "15000000000000",
  "serviceFeeWei": "5000000000000",
  "gasFeeWei": "10000000000000",
  "expiresAt": "2026-02-04T16:00:00Z"
}
```

## Step 3: Get Authorization Data

Get the EIP-712 typed data for signing:

```bash
curl -X POST https://zerodust-backend-production.up.railway.app/authorization \
  -H "Content-Type: application/json" \
  -d '{"quoteId": "uuid-from-quote"}'
```

Response contains `typedData` (EIP-712 for sweep) and `eip7702` (delegation parameters).

## Step 4: User Signs Messages

The user must sign:
1. **EIP-7702 delegation authorization** - Delegates their EOA to ZeroDust contract
2. **EIP-7702 revoke authorization** - Pre-signed revocation (executed after sweep)
3. **EIP-712 sweep intent** - Authorizes the specific sweep parameters

## Step 5: Submit Sweep

```bash
curl -X POST https://zerodust-backend-production.up.railway.app/sweep \
  -H "Content-Type: application/json" \
  -d '{
    "quoteId": "uuid",
    "delegationSignature": "0x...",
    "revokeSignature": "0x...",
    "sweepSignature": "0x..."
  }'
```

Response:
```json
{
  "sweepId": "uuid",
  "status": "pending",
  "txHash": null
}
```

Poll `GET /sweep/{sweepId}` for status updates until `status: "completed"`.

## Convenience Endpoint: Combined Quote + Auth

For agents, use this single endpoint to get quote and auth data together:

```bash
curl -X POST https://zerodust-backend-production.up.railway.app/agent/sweep \
  -H "Content-Type: application/json" \
  -H "X-API-Key: $ZERODUST_API_KEY" \
  -d '{
    "fromChainId": 42161,
    "toChainId": 8453,
    "userAddress": "0x...",
    "destination": "0x..."
  }'
```

## Batch Sweeps (Multiple Chains)

Sweep from multiple chains in one request:

```bash
curl -X POST https://zerodust-backend-production.up.railway.app/agent/batch-sweep \
  -H "Content-Type: application/json" \
  -H "X-API-Key: $ZERODUST_API_KEY" \
  -d '{
    "sweeps": [
      {"fromChainId": 42161},
      {"fromChainId": 10},
      {"fromChainId": 137}
    ],
    "destination": "0x...",
    "consolidateToChainId": 8453
  }'
```

## Fees

- **Service fee:** 1% of balance (min $0.05, max $0.50)
- **Gas costs:** Paid by ZeroDust, reimbursed from sweep amount
- **User receives:** ~97-99% of balance (varies by gas prices)

## Rate Limits

- Agent keys: 300 requests/minute, 1000 sweeps/day
- Contact ZeroDust for higher limits

## Error Codes

| Error | Meaning |
|-------|---------|
| `BALANCE_TOO_LOW` | Balance below minimum (~$0.10) |
| `QUOTE_EXPIRED` | Quote older than 5 minutes |
| `CHAIN_NOT_SUPPORTED` | Chain doesn't support EIP-7702 |
| `INVALID_SIGNATURE` | Signature verification failed |
| `RATE_LIMIT_EXCEEDED` | Daily or per-minute limit hit |

## Example Agent Conversation

**User:** "I want to move all my ETH from Arbitrum to Base"

**Agent:**
1. Call `/quote` to check balance and fees
2. Show user: "You have 0.005 ETH on Arbitrum. After fees (~1%), you'll receive ~0.00495 ETH on Base. This requires signing 3 messages. Proceed?"
3. If yes, call `/authorization` to get typed data
4. Request wallet signatures (EIP-7702 delegation, revoke, and EIP-712 sweep)
5. Submit to `/sweep` with signatures
6. Poll status until complete
7. Confirm: "Done! Your Arbitrum balance is now exactly 0. 0.00494 ETH received on Base."

## Important Notes

1. **EIP-7702 Required:** User's wallet must support EIP-7702. Most modern wallets do as of 2026.

2. **Signatures Required:** Sweeps require user wallet signatures. ZeroDust never has custody.

3. **Zero Balance Result:** After sweep, source chain balance is EXACTLY zero.

4. **Cross-Chain:** Sweeps can go to any supported destination chain via Gas.zip bridging.

5. **Not All EVM Chains:** Only the 25 chains listed above support EIP-7702. Do not attempt sweeps on unsupported chains.
