# 指标定义和计算逻辑

## 📊 效率指标

### 1. 任务完成率 (Completion Rate)

```
完成率 = (完成任务数 / 总任务数) × 100%
```

**说明:**
- 任务状态为 `done` 或 `closed` 视为完成
- 反映员工的交付能力
- **健康范围**: 80%-95%

---

### 2. 工时效率比 (Efficiency Ratio)

```
工时效率比 = 预估工时总和 / 实际工时总和
```

**说明:**
- > 1: 实际用时少于预估，效率高
- = 1: 预估准确
- < 1: 实际用时超出预估，效率低
- **健康范围**: 0.9-1.2

---

### 3. 平均任务耗时 (Average Task Hours)

```
平均任务耗时 = 实际工时总和 / 完成任务数
```

**说明:**
- 反映单任务平均成本
- 用于横向对比不同员工
- 需结合任务难度分析

---

### 4. 延期率 (Overdue Rate)

```
延期率 = (延期任务数 / 总任务数) × 100%
```

**说明:**
- 延期：实际完成时间 > 计划完成时间
- 反映时间管理能力
- **健康范围**: < 10%

---

## 📈 饱和度指标

### 1. 工作负载率 (Workload Rate)

```
工作负载率 = (实际工时 / 标准工时) × 100%
```

**说明:**
- 标准工时：40 小时/周（可按公司政策调整）
- **健康范围**: 70%-90%
- > 100%: 过载，需要关注
- < 40%: 低负载，可分配更多任务

---

### 2. 任务密度 (Task Density)

```
任务密度 = 任务数 / 工作日数
```

**说明:**
- 反映单位时间内的任务数量
- **健康范围**: 3-8 个/天
- 过高可能导致质量下降

---

### 3. 多任务指数 (Multitasking Index)

```
多任务指数 = 平均并行任务数
```

**说明:**
- 并行任务：同一时间段内进行的任务
- **健康范围**: 2-5 个
- 过多可能导致注意力分散

---

## 🎯 难度系数

### 任务难度分级

| 等级 | 分值 | 说明 |
|------|------|------|
| 简单 | 1 | 常规任务，无需特殊技能 |
| 普通 | 2-3 | 需要一定经验 |
| 困难 | 4 | 需要专业技能 |
| 极难 | 5 | 复杂问题，需要专家级能力 |

### 难度加权效率

```
加权效率 = Σ(任务工时 × 难度系数) / 总工时
```

**说明:**
- 考虑任务难度的综合效率
- 更公平地评估高难度任务贡献

---

## 🔍 异常检测

### 过载预警

触发条件（满足任一）:
- 工作负载率 > 120%
- 连续 3 天工作 > 10 小时
- 并行任务数 > 8

### 低负载预警

触发条件（满足任一）:
- 工作负载率 < 30%
- 任务密度 < 2 个/天
- 连续 3 天无任务更新

### 效率异常

触发条件:
- 工时效率比 < 0.5（严重低估）
- 工时效率比 > 2.0（严重高估）
- 延期率 > 30%

---

## 📋 报告模板

### 个人报告结构

```markdown
# [姓名] 工作效率报告

## 基本信息
- 统计周期：YYYY-MM-DD ~ YYYY-MM-DD
- 总任务数：X
- 完成任务数：Y

## 效率指标
- 完成率：X%
- 工时效率比：X.XX
- 平均任务耗时：X.Xh

## 饱和度
- 工作负载率：X%
- 饱和度等级：正常/饱和/过载

## 趋势分析
[图表或文字描述]

## 改进建议
[具体建议]
```

### 团队报告结构

```markdown
# 团队工作效率分析报告

## 团队概览
- 总人数：X
- 总任务数：Y
- 平均完成率：Z%

## 效率排名
[排名列表]

## 饱和度分布
- 过载：X 人
- 饱和：Y 人
- 正常：Z 人
- 低负载：W 人

## 风险预警
[需要关注的人员和事项]

## 优化建议
[资源分配、流程改进等建议]
```

---

## 📊 数据可视化建议

### 推荐图表

1. **柱状图**: 员工任务数对比
2. **折线图**: 工时趋势变化
3. **饼图**: 任务类型分布
4. **热力图**: 团队饱和度分布
5. **散点图**: 效率 vs 难度关系

### 颜色编码

- 🟢 正常：绿色
- 🟡 注意：黄色
- 🟠 预警：橙色
- 🔴 危险：红色
