---
name: zeelin-meetinginstructions
description: 从会议记录（腾讯会议、飞书会议、钉钉会议等）中提取领导对特定成员的指导意见、工作要求和行动计划。当用户提到"提取会议指导""会议纪要中的任务""领导对XX的要求""从会议记录中整理待办"等场景时触发此skill。也适用于：从组会/周会/项目会记录中抽取某人的action items、整理导师对学生的指导建议、提取上级对下属的工作安排。支持中英文会议记录。
---

# 会议指导意见提取器 (Meeting Guidance Extractor)

## 适用场景

从会议转写文本中提取**领导/导师对特定成员**的指导意见和工作要求。这类需求常见于：

- 学术组会：导师对学生的研究指导
- 团队周会：领导对下属的工作安排
- 项目评审会：负责人对成员的改进要求
- 一对多会议：领导在与不同人对话中提到某人的工作期望

## 核心挑战

会议转写文本有几个特点需要特别注意：

1. **领导发言量占绝对主导**：这类会议中领导通常是发言最多的人，占全部发言量的50%-80%甚至更多。领导会对每个成员逐一点评、展开讨论、穿插闲聊和感想，因此绝大部分领导发言与目标成员无关。提取时必须精准过滤，避免被海量无关发言淹没
2. **信息分散且存在跨对话延伸**：领导对某人的指导可能散落在整个会议中。除了与该人的直接对话外，领导常在与其他成员对话时**延伸、补充、深化**对目标成员的指导——比如领导在和A讨论时突然说"刚才B做的那个XX，可以从YY角度继续研究"，这类跨对话延伸往往包含更高层次的战略性指导，是最容易遗漏的高价值内容
3. **领导对话风格多样且有个人特征**：领导的指导风格需要被识别和适应，常见模式包括：打断学生汇报并直接纠正方向（打断本身就传达了"这个不重要/不对"的信号）、用自身经历做类比来传达方法论（类比中蕴含可迁移的核心原则）、在泛泛讨论中突然收束到具体要求、对不同话题投入不同的展开篇幅（篇幅长度本身反映重视程度）
4. **语音转写噪声**：ASR转写会有错别字、断句错误、语气词干扰
5. **隐含指令**：领导的要求可能以建议、反问、举例等间接方式表达，而非直接命令
6. **上下文依赖**：有些指令需要结合会议的整体讨论才能理解含义
7. **通用方法论中隐藏个人指导**：领导在对全组阐述通用方法论或对其他成员讲解时，这些观点可能直接适用于目标成员的工作，但因为没有点名而容易被过滤掉

## 执行步骤

### 第一步：确认提取参数

向用户确认以下信息（如果用户消息中已经明确，则无需再问）：

| 参数 | 说明 | 示例 |
|------|------|------|
| **领导姓名/标识** | 会议记录中领导的发言人标记 | "新媒沈阳"、"张总"、"王老师" |
| **目标成员姓名** | 需要提取指导的成员 | "滕婕"、"李四" |
| **会议记录来源** | 用户会直接粘贴文本或上传文件 | 腾讯会议转写、飞书妙记等 |

### 第二步：全文扫描与片段标记

对会议全文进行四轮扫描：

**第一轮：直接对话扫描**
- 找出领导与目标成员之间的所有直接对话段落
- 标记每段对话的时间位置（如有）和主题
- 注意领导的"打断"行为：如果领导在目标成员汇报中途打断，打断本身就是信号——说明领导认为被打断的内容不重要，或方向不对，或需要立刻纠正

**第二轮：间接提及与跨对话延伸扫描**
这是最容易遗漏高价值内容的环节，必须特别仔细：
- **显式提及**：领导在与其他人对话时直接说出目标成员的姓名或代称（"你们""她/他"等）
- **跨对话延伸**：领导在与其他成员讨论相似话题时，引用或延伸了与目标成员对话的内容（如"刚才XX做的那个YY，可以从ZZ角度继续"）。这类延伸往往包含比直接对话中更高层次的战略性思考，因为领导在与他人交流时触发了新的联想
- **工作领域关联**：领导在讨论与目标成员工作领域直接相关的话题时，即使没有点名，相关指导也可能适用

**第三轮：通用方法论提取**
领导常在会议中反复阐述适用于全组的方法论、价值观和工作标准。这些虽非专门针对目标成员，但如果与其工作直接相关则必须提取：
- 识别领导反复强调的核心原则（出现2次以上的观点）
- 判断该原则是否直接适用于目标成员当前的工作内容
- 如适用，在输出报告中标注为"通用方法论（适用于目标成员的XX工作）"
- 典型场景：领导对A讲"Skill要展示安全、效率、质量"，虽然A不是目标成员，但目标成员也在做Skill，此方法论直接适用

**第四轮：上下文补充扫描**
- 找出目标成员自己的发言（用于理解领导回应的背景）
- 找出与目标成员工作直接相关的其他成员讨论
- 找出领导用自身经历做类比的段落——类比中常蕴含可迁移的核心方法论

### 第三步：信息分类与结构化

将扫描到的内容按以下维度分类：

1. **明确的工作指令**：领导直接布置的具体任务（"你去做XX"、"下周把XX交出来"）
2. **方向性指导**：领导指出的研究/工作方向（"你应该往XX方向想"、"这个思路可以"）
3. **质量要求与标准**：领导对工作成果的期望标准（"要做到XX水平"、"参考XX的做法"）
4. **时间节点与优先级**：提到的截止日期、先后顺序
5. **批评与改进建议**：对已有工作的不满或改进意见
6. **资源与协作安排**：领导建议的协作对象、可用资源
7. **适用的通用方法论**：领导对全组或对其他成员阐述的方法论中，直接适用于目标成员工作的部分

### 第三步附加：优先级判断

对提取到的指导内容进行优先级排序。领导虽然不会明说"这条最重要"，但会通过以下信号传递优先级，需要综合判断：

**高优先级信号：**
- **用词强度**：使用"极其重要""极其重大""关键""核心"等强调词
- **展开篇幅**：在某个话题上投入大量时间深入展开（多个段落持续讨论）
- **主动延伸**：领导不仅回应，还主动提出新的思路、研究问题、具体方案
- **跨对话复现**：在与不同成员对话时反复提及同一主题
- **亲自举例**：领导用自己的亲身经历来类比说明

**低优先级信号：**
- **简短回应**："可以""行""继续"等短回复
- **定性为"继续/延续"**：将工作定性为"以前工作的继续"而非新突破
- **快速跳过**：打断后迅速转移到其他话题
- **语气平淡**：没有特别的强调或情感投入

### 第四步：生成输出报告

按以下模板输出结果。保持语言简洁，用行动导向的表述：

---

## 输出模板

```
# [领导姓名] 对 [成员姓名] 的指导摘要

> 会议：[会议名称/日期]
> 目标成员发言时段：[起止时间]
> 间接提及时段：[时间点列表]

## 一、核心行动项（Action Items）

按优先级排列，每条包含：
- 具体任务描述
- 优先级标记：🔴高 / 🟡中 / 🟢低（基于领导用词强度、展开篇幅、主动延伸程度判断）
- 来源语境（简述领导原话场景，标注来源类型：直接对话 / 跨对话延伸 / 通用方法论）
- 截止时间（如有提及）

## 二、方向性指导

领导对成员工作方向的宏观指引，包括：
- 鼓励的方向（标注领导的重视程度）
- 否定或暂缓的方向（标注领导通过何种方式表达否定：直接否定/打断/轻描淡写）
- 建议参考的标杆/案例（特别注意领导用自身经历做的类比，提炼可迁移原则）

## 三、质量标准与期望

领导对成果质量的要求，包括：
- 明确提出的标准
- 通过举例暗示的期望水平

## 四、适用的通用方法论

领导在会议中阐述的通用原则中，直接适用于目标成员工作的部分：
- 方法论内容
- 适用于目标成员的哪项具体工作
- 来源（领导在与谁对话时提出）

## 五、协作与资源

- 建议联系/协作的人
- 可使用的工具或平台
- 需要汇报的对象和方式

## 六、关键原话摘录

摘录3-5条最重要的领导原话（保留口语风格），标注上下文：
- "[原话]" —— 场景说明（直接对话 / 与XX对话时提及）

## 七、注意事项

- 领导未明说但从语气/上下文可推断的隐含期望（标注[推测]及推测依据）
- 领导通过不同话题的展开篇幅差异所暗示的真实优先级
- 与其他成员的任务有交叉或依赖的部分
- 领导在打断目标成员时传递的信号（哪些汇报内容被认为不重要/方向不对）
```

---

## 处理技巧

### 领导对话风格识别
不同领导有不同的指导风格，识别这些风格模式对准确提取至关重要：

**打断模式**：领导在成员汇报中途打断，这不是粗鲁而是高效信号传递。被打断的内容通常意味着"不重要""不需要讲""方向不对"。打断后领导说的话往往才是真正的指导核心。
- 示例："这些调用谁的都不重要，这些都不用讲" → 意味着技术实现细节不是汇报重点

**类比模式**：领导用自身经历或他人经历做长段类比。类比表面上是在讲故事，实际是在传达可迁移的核心方法论。必须提炼出类比背后的抽象原则。
- 示例：领导讲自己"做反剽窃系统写了9篇文章" → 核心原则是"围绕一个点做到统治性地位"

**递进模式**：领导先简要回应目标成员，然后在与后续其他成员对话时触发新联想，回过头来补充更深层的指导。后续补充往往比直接回应更有战略价值。

**否定-引导模式**：领导先否定成员的做法，然后给出正确方向。否定和引导是成对出现的，提取时两者都要记录。
- 示例："我们现在做的逻辑不对"（否定）→ "需求分析引擎有了，然后我们再来倒推"（引导）

### 领导海量发言的高效过滤策略
领导是会议中发言最多的人，通常会逐一与每位成员对话、点评、展开延伸讨论。处理方式：

1. **先定位对话段落边界**：会议转写通常按发言人标记分段。先识别出领导与不同成员的对话"回合"——当发言人从"成员A"切换到"成员B"时，领导的话题通常也随之切换
2. **建立关注区与非关注区**：
   - **核心关注区**：领导与目标成员直接对话的段落（目标成员发言前后的领导发言）→ 逐句精读
   - **高价值延伸区**：领导与其他成员对话时引用了目标成员的话题或工作内容 → 逐句精读（这里常包含比直接对话更高层次的指导）
   - **方法论关注区**：领导对其他成员讲解通用方法论的段落 → 判断是否适用于目标成员的工作
   - **低优先区**：领导与其他成员讨论与目标成员完全无关话题的段落 → 快速略过，仅检索目标成员姓名
3. **注意话题漂移**：领导常在与A成员对话时突然提到B成员（如"刚才B做的那个XX，可以从YY角度继续研究"），这类跨对话提及容易遗漏，必须全文检索目标成员姓名/代称
4. **区分领导的通用感想与可迁移方法论**：领导发言量大的一个原因是会穿插大量通用观点。区分方式——如果领导的通用阐述涉及目标成员正在做的具体工作类型（如目标成员在做Skill，领导对另一人讲了Skill的质量标准），则应纳入"适用的通用方法论"

### 语音转写纠错
会议转写文本常见问题：
- 人名错误：根据上下文和发言人标记修正（如"滕杰"可能是"滕婕"）
- 术语错误：根据领域知识修正（如"open cloud"可能是"OpenClaw"）
- 断句错误：根据语义重新划分句子边界

### 隐含指令识别
注意以下表达模式，它们通常是间接指令：
- 反问句："你为什么不试试XX？" = 建议尝试XX
- 举例句："像XX那样做就很好" = 要求参考XX的做法
- 否定句："这个不是我们要的" = 停止当前方向
- 期望句："如果能XX就好了" = 要求实现XX
- 对比句："别人都XX了" = 要求跟上进度
- 打断句：在成员汇报中途打断并转向另一个话题 = 被打断的内容不重要，转向的话题才是重点
- 类比句：领导讲自己或他人的经历 = 要求从中提炼方法论并应用到自己工作中
- 篇幅信号：领导在某个话题上展开5分钟以上 = 这是领导真正关心的核心议题
- 重复信号：领导在不同场合反复提到同一观点 = 这是最高优先级的要求

### 区分通用要求与个人要求
领导有时会发表针对全组的通用要求。分三层判断与目标成员的关联度：

**强关联（必须提取）：**
- 在目标成员发言后紧接着说的通用要求
- 点名或用代词明确指向目标成员
- 涉及目标成员正在做的具体工作类型（如目标成员在做Skill，领导对另一人讲Skill标准）

**中关联（作为"适用的通用方法论"提取）：**
- 领导反复强调的核心原则（在会议中出现2次以上），且与目标成员工作性质相关
- 领导对其他成员指出的错误，目标成员也可能犯同样的错误
- 领导用自身经历做的类比，其中的方法论适用于目标成员的发展阶段

**弱关联（不提取）：**
- 与目标成员工作领域完全无关的行业评论
- 纯粹的闲聊、玩笑
- 针对其他成员的私人事务

### 处理信息不足的情况
如果会议记录中目标成员出现很少或未出现：
- 明确告知用户"在提供的会议记录中，[成员姓名]的相关内容较少"
- 列出所有间接相关的内容
- 建议用户确认是否遗漏了部分会议记录

## 输出要求

- 语言：与会议记录保持一致（中文会议输出中文，英文会议输出英文）
- 风格：行动导向、简洁明确，避免冗余描述
- 原话摘录：保留口语风格，不做文学化润色
- 不确定内容：用"[推测]"标记，并说明推测依据