# 文科论文提示词模板

## 1) 通用角色设定

请在接下来的所有写作中严格遵守以下总体要求：
1. 学术化与严谨性：语言必须严谨、精练、学术化，避免口语化与冗余描述。
2. 理论深度与逻辑性：所有论述均应有明确逻辑脉络和因果、递进、归纳或对比关系，体现深厚的理论素养和分析功力，不得浮于表面。
3. 创新性与思辨性：注重理论创新与学理提升，善于提出新问题、新视角，并进行独到分析和学术思辨。
4. 时代意义与实践关联：在适当场合体现时代意义和现实关联，为学术理论与实践发展提供有价值的参考与启示。
5. 整体风格统一：研究方向、框架、引言、综述、论证、对策建议、总结、摘要、关键词风格保持一致，前后呼应，逻辑连贯，不使用 Markdown。

## 2) 题目生成模板

基于参考文献的题目，提出一个研究题目。应具备以下特点：
1. 符合提供的参考文献，与研究背景和文献综述内容紧密相关。
2. 显著创新性，能填补现有研究空白或提出新问题。
3. 高学术价值，推动该领域发展。
4. 引起学者与高影响力期刊关注。
5. 体现严谨学术态度和深刻理论理解，具有潜在应用或理论拓展价值。
6. 在批判性回顾基础上融合经典理论范式，提出新的研究问题。

输入：
- 参考文献：`{参考文献}`

返回要求：
1. 仅返回中文题目本身。
2. 不要包含“题目”字样。
3. 不要包含星号、引号、书名号、特殊符号和换行。

## 3) 大纲生成模板

根据题目和简要综述，生成详细框架。
- 标题：`{题目}`
- 简要综述：`{综述}`

框架要求：
1. 标准格式：一、引言；二、综述；三、论证；四、建议；五、结论。
2. 综述章节根据综述报告提取主要研究问题。
3. 论证章节包含 `{论证数}` 个小节，结构和逻辑关系灵活。
4. 建议章节提出 `{建议数}` 个有深度与观点性的建议。

输出 JSON：
```json
{
  "引言": "用一句话简单概括全文引言",
  "综述": [{"zs": "主要研究问题的小标题"}],
  "论证": [{"lz": "论证小标题"}],
  "建议": [{"jy": "具体建议或策略的小标题"}],
  "结论": "用一句话概括全文研究结论"
}
```

## 4) 引言模板

基于已定论文框架：
- 题目：`{题目}`
- 框架：`{框架}`

写作要求：
1. 标题为“一、引言”，500-800 字，分为两个自然段，不引用文献。
2. 第一段：政策背景与选题意义。
3. 第二段：研究问题与创新贡献。
4. 最后一句固定为：“本文面向……对象，基于……理论，利用……方法，以期实现……目的。”

第一段细化：
- 前半：政策背景、法规战略、实施效果、机遇与挑战。
- 后半：学术意义与实践意义。

第二段细化：
- 前半：列出核心问题或研究假设。
- 后半：说明创新贡献（方法/视角/未解决问题），与研究意义区分。

## 5) 综述收束段（研究流程）模板

输入：
- 题目：`{题目}`
- 框架：`{框架}`
- 引言：`{引言}`
- 文献综述：`{综述}`

目标：为综述最后一段提出研究流程，开头明确对应要解决的问题个数，并按“首先/其次/然后/最后”组织：
- 首先：基于何种数据或对象，进行何种分析。
- 其次：如何设计研究方法并提出方案。
- 然后：关键发现分点说明，语言对称、排比。
- 最后：创新点分点说明，语言对称、排比。

## 6) 论证模板

输入：
- 题目：`{题目}`
- 框架：`{框架}`
- 引言：`{引言}`
- 综述：`{综述}`

要求：
1. 标题“三、论证”，总字数 8000 字以上，三个逻辑关联自然段。
2. 按框架分 3 个小节，编号 `1.` `2.` `3.`，深度展开并强调引言中方法。
3. 每个小节分两段，编号 `1.1` `1.2` `2.1` `2.2` `3.1` `3.2`。
4. 引用文献按全文顺序编号，并与综述统一。

建议内容骨架：
- 1. 理论背景与核心概念
- 1.1 核心概念（>1000 字）
- 1.2 关键特征（>1000 字）
- 2. 研究问题多维分析
- 2.1 多维特征与复杂性（>1500 字）
- 2.2 影响及现实意义（>1500 字）
- 3. 理论贡献与实践价值
- 3.1 创新性与学术贡献（>1500 字）
- 3.2 实践价值与应用前景（>1500 字）

## 7) 对策建议模板

输入：
- 题目：`{题目}`
- 框架：`{框架}`
- 引言：`{引言}`
- 论证：`{论证}`

要求：
1. 标题“四、对策建议”，总字数 >2000。
2. 按框架分层展开，每层约 800 字，逻辑递进。
3. 不引用文献，强调有价值、可执行的建议。
4. 每个小节不分段，使用一个完整段落。

建议结构：
- 解决对策（>1000 字）：给出实施步骤，强调研究方法如何落地。
- 实施条件与挑战（>1000 字）：资金/政策/技术条件、潜在阻力、调整方案。

## 8) 结论模板

输入：
- 题目：`{题目}`
- 框架：`{框架}`
- 引言：`{引言}`
- 综述：`{综述}`
- 论证：`{论证}`
- 对策建议：`{对策建议}`

要求：
1. 标题“五、结论”，一个自然段，小于 400 字。
2. 第一句：总结研究重点和主要结论。
3. 第二句：提出未来研究方向。
4. 第三句：升华时代意义与价值。
5. 不引用文献。

## 9) 摘要模板

输入：
- 题目：`{题目}`
- 引言：`{引言}`
- 综述：`{综述}`
- 论证：`{论证}`
- 对策建议：`{对策建议}`
- 结论：`{结论}`

要求：
1. 不使用标题。
2. 包含研究目的、方法、结果、结论。
3. 一个自然段，100-400 字，不引用文献。

## 10) 关键词模板

输入：
- 题目：`{题目}`
- 摘要：`{摘要}`
- 数量：`{关键词数}`

输出格式：
`关键词：XX；XX；XX`
