---
name: ZeeLin Liberal Arts Paper
slug: zeelin-liberal-arts-paper
version: 1.0.1
description: 高校硕博研究生必备，文科论文 AI 全流程创作助手：自动生成论文标题、大纲、引言、综述、论证、对策建议和结论，强调理论深度和思辨性，支持自定义章节数量 - Powered by ZeeLin
author: 刘东江 (@lidngjing317853)
license: MIT
homepage: https://melodylab.top
tags: [academic, paper, liberal-arts, social-science, chinese, writing, zeelin]
requires:
  - capability: file-system
---

## 📋 隐私与透明度

**本地处理**: 
- 所有论文生成过程在本地完成
- 不上传用户的论文内容、参考文献或研究数据到任何服务器
- 不收集任何个人信息或研究数据

**数据安全**: 
- ✅ 完全本地化运行
- ✅ 无外部 API 调用
- ✅ 无数据泄露风险
- ✅ 符合学术保密要求

---

## 使用时机

当用户请求：
- 写文科论文 / 社科论文
- 生成论文框架或章节
- 按固定模板输出论文提示词
- 把论文流程标准化
- 根据参考文献写论文

适用学科：
- 社会学、政治学、法学
- 教育学、心理学
- 新闻传播学、管理学
- 经济学、历史学等

不适合：
- 理工科论文（请使用 ZeeLin Academic Paper）
- 非学术性写作

---

## 核心功能

### 🎯 全流程自动化

从零开始到完整论文，一站式生成：

1. **智能题目生成**
   - 基于参考文献分析研究空白
   - 融合经典理论范式提出新问题
   - 确保创新性和学术价值

2. **结构化大纲设计**
   - 自动生成标准五段式结构（引言、综述、论证、建议、结论）
   - 支持自定义论证数量和建议数量
   - JSON 格式清晰展示逻辑框架

3. **逐章节内容生成**
   - 引言：研究背景、问题陈述、创新点
   - 综述：文献回顾、研究流程
   - 论证：理论分析、实证研究、批判性思考
   - 对策建议：有深度和观点性的政策建议
   - 结论：总结、局限性、未来研究方向
   - 摘要与关键词：提炼核心内容

### ✨ 学术质量保证

- **理论深度**：体现深厚的理论素养和分析功力
- **思辨性强**：善于提出新问题、新视角并进行独到分析
- **逻辑严密**：因果、递进、归纳或对比关系清晰
- **学术化语言**：严谨、精练、避免口语化
- **跨章节一致性**：引言中的方法在论证和建议中必须体现

### 🛠️ 灵活定制

- 自定义论证小节数量（默认 3 个）
- 自定义建议数量（默认 3 个）
- 自定义关键词数量（默认 5 个）
- 支持用户提供题目或自动生成
- 支持纯文本或结构化 JSON 输出

---

## Agent 执行流程

### 第 1 步：收集输入

询问或推断用户需要：

**必需输入**：
- 参考文献列表（至少 1-3 篇）
- 综述材料或研究背景

**可选输入**：
- 论文题目（没有则自动生成）
- 论证数量（默认 3）
- 建议数量（默认 3）
- 关键词数量（默认 5）

**交互示例**：
> "你好！我可以帮你生成文科论文 📝
> 
> 请提供：
> 1. 参考文献题目或内容（至少 1-3 篇）
> 2. 研究背景或综述材料
> 3. （可选）论文题目、论证数量、建议数量
> 
> 你想研究什么方向？"

### 第 2 步：生成题目（如需要）

如果用户未提供题目，调用题目生成模板：

- 基于参考文献分析研究空白
- 融合经典理论范式
- 提出新的研究问题

**示例输出**：
> "基于你的参考文献，我建议的论文题目是：
> 
> **《数字化时代下社会治理创新的理论框架与实践路径研究》**
> 
> 满意吗？（回复'确认'或'修改为 XXX'）"

### 第 3 步：生成大纲

调用大纲生成模板，输出 JSON 结构：

```json
{
  "引言": "概述研究背景、问题与创新点",
  "综述": [
    {"zs": "社会治理理论的演进脉络"},
    {"zs": "数字化时代的治理挑战"}
  ],
  "论证": [
    {"lz": "数字治理的理论逻辑与分析框架"},
    {"lz": "社会治理创新的实践困境与破解路径"},
    {"lz": "技术赋能与制度保障的协同机制"}
  ],
  "建议": [
    {"jy": "构建多元主体协同的数字治理平台"},
    {"jy": "完善数据安全与隐私保护的法律体系"},
    {"jy": "加强数字素养教育与能力建设"}
  ],
  "结论": "总结研究发现、局限性与未来方向"
}
```

**展示给用户确认**：
> "论文大纲已生成，请查看：
> [显示 JSON 大纲]
> 
> 满意吗？需要调整章节数量或标题吗？"

### 第 4 步：逐章节生成内容

按顺序生成各章节：

1. **引言** → 展示给用户确认
2. **综述最后一段与研究流程** → 确认
3. **论证（每个小节逐一生成）** → 确认
4. **对策建议** → 确认
5. **结论** → 确认
6. **摘要与关键词** → 完成

每个章节生成后，询问用户：
> "【引言】章节已生成，请查看：
> [内容]
> 
> 满意吗？（回复'确认'继续下一章，或'修改XXX'）"

### 第 5 步：输出完整论文

将所有章节合并，输出完整论文（纯文本格式，不含 Markdown）：

```
【题目】
数字化时代下社会治理创新的理论框架与实践路径研究

【摘要】
本研究基于数字治理理论...

【关键词】
数字治理；社会治理创新；多元协同；...

一、引言
...

二、综述
...

三、论证
（一）数字治理的理论逻辑与分析框架
...

四、对策建议
（一）构建多元主体协同的数字治理平台
...

五、结论
...
```

---

## 资源使用

**加载模板文件**：
- 读取 `references/prompts_zh.md` 获取所有章节模板
- 直接复用模板中的占位符和约束条件
- 不要重写模板结构

**模板优先级**：
- 如果用户约束与模板约束冲突，优先用户约束并说明调整

---

## 输出规则

### 学术规范

1. **语言风格**：严谨、精练、学术化，避免口语化
2. **理论深度**：体现深厚的理论素养，不浮于表面
3. **逻辑脉络**：明确因果、递进、归纳或对比关系
4. **创新性**：提出新问题、新视角并进行学术思辨
5. **时代意义**：体现现实关联，提供有价值的参考
6. **风格统一**：所有章节风格一致，前后呼应，不使用 Markdown

### 格式要求

- 纯文本输出（除非用户指定其他格式）
- 标题层级清晰（一、二、三 / （一）（二）（三））
- 不含特殊符号（星号、引号、书名号等）
- 不含换行冗余

### 质量检查

- 方法一致性：引言中提到的方法必须在论证和建议中体现
- 结论对应：结论必须与前文发现相匹配
- 引用规范：所有论述有据可查（基于参考文献）

---

## 快捷指令示例

- `/paper 数字时代的社会治理创新研究`
- `/paper 根据这 3 篇文献写一篇文科论文 [文献列表]`
- `/paper 生成论文框架和章节`

---

## 注意事项

### 学术诚信

⚠️ **重要提醒**：
- 本工具生成的内容仅供参考和启发
- 用户需对最终论文内容负责
- 必须引用所有参考文献来源
- 不得抄袭或伪造数据
- 建议人工审阅和修改生成内容

### 使用建议

1. **提供高质量参考文献**：参考文献质量直接影响生成质量
2. **详细的研究背景**：背景越详细，生成内容越精准
3. **逐步确认**：每个章节生成后及时确认，避免后续大幅修改
4. **人工润色**：生成后建议人工审阅、补充细节和调整表述
5. **理论深化**：建议补充具体理论分析和案例

---

## 支持与反馈

- **开发者**: 刘东江 (@lidngjing317853)
- **项目主页**: https://melodylab.top
- **问题反馈**: 通过 ClawHub 或项目主页联系

---

## 示例对话流程

**用户**："帮我写一篇关于数字时代社会治理创新的论文"

**Agent**：
> "你好！我可以帮你生成文科论文 📝
> 
> 请提供：
> 1. 参考文献题目或内容（至少 1-3 篇）
> 2. 研究背景或综述材料
> 
> 关于'数字时代社会治理创新'，你有哪些参考文献？"

**用户**："文献 1：数字治理的理论与实践；文献 2：..."

**Agent**：
1. 生成题目建议
2. 展示大纲 JSON
3. 逐章节生成并确认
4. 输出完整论文

**最终输出**：
> "✅ 论文生成完成！
> 
> [完整论文内容]
> 
> 📝 温馨提示：
> - 请人工审阅并补充理论深度
> - 记得引用所有参考文献
> - 建议增加具体案例和数据支撑"
