# ZeeLin Liberal Arts Paper 📝

**文科论文 AI 全流程创作助手** - 从选题到完稿，一站式生成高质量社科论文

[![Version](https://img.shields.io/badge/version-1.0.0-blue.svg)](https://clawhub.ai/skills/zeelin-liberal-arts-paper)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE)
[![OpenClaw](https://img.shields.io/badge/OpenClaw-Skill-orange.svg)](https://openclaw.ai)

## ✨ 核心优势

### 🎯 全流程自动化
- **智能题目生成** - 基于参考文献融合理论范式提出新问题
- **结构化大纲设计** - 标准五段式结构，逻辑清晰
- **逐章节内容生成** - 从引言到结论，一站式完成

### ✨ 学术质量保证
- **理论深度** - 体现深厚的理论素养和分析功力
- **思辨性强** - 善于提出新问题、新视角并进行独到分析
- **逻辑严密** - 因果、递进、归纳或对比关系清晰
- **学术化语言** - 严谨、精练、避免口语化

### 🛠️ 灵活定制
- 自定义论证小节数量（默认 3 个）
- 自定义建议数量（默认 3 个）
- 自定义关键词数量（默认 5 个）
- 支持纯文本或 JSON 格式输出

### 🔒 完全本地化
- **无数据上传** - 所有处理在本地完成
- **无隐私风险** - 不调用任何外部 API
- **符合学术保密要求** - 研究数据完全由你控制

## 🚀 快速开始

### 安装

```bash
# 使用 ClawHub CLI
clawhub install zeelin-liberal-arts-paper

# 或者手动克隆
git clone https://github.com/yourusername/zeelin-liberal-arts-paper.git ~/.openclaw/workspace/skills/zeelin-liberal-arts-paper
```

### 使用示例

**完整流程**:
```
你: 帮我写一篇关于数字时代社会治理创新的论文
AI: [询问参考文献和研究背景]
你: [提供 2-3 篇参考文献和简要背景]
AI: [生成题目建议]
你: 确认
AI: [生成大纲 JSON 并展示]
你: 确认
AI: [逐章节生成并等待确认]
你: 确认/修改
AI: [最终输出完整论文]
```

**快捷指令**:
```
/paper 数字时代的社会治理创新研究
/paper 根据这 3 篇文献写一篇文科论文 [文献列表]
/paper 生成论文框架和章节
```

## 📋 生成内容结构

```
【题目】
自动生成或用户提供

【摘要】
提炼研究核心内容

【关键词】
5-8 个关键词

一、引言
- 研究背景
- 问题陈述
- 创新点

二、综述
- 文献回顾
- 研究流程

三、论证
（一）理论分析
（二）实证研究
（三）批判性思考
...（支持自定义数量）

四、对策建议
（一）具体建议 1
（二）具体建议 2
...（支持自定义数量）

五、结论
- 研究总结
- 局限性
- 未来研究方向
```

## 🎓 支持的论文类型

### ✅ 适用学科
- **社会科学**：社会学、政治学、法学
- **人文学科**：教育学、心理学、历史学
- **应用学科**：新闻传播学、管理学、经济学
- **中文论文写作**

### ❌ 不适用场景
- 理工科论文（请使用 ZeeLin Academic Paper）
- 自然科学论文
- 非学术性写作

## 🌟 与理工科论文 Skill 的区别

| 特性 | ZeeLin Liberal Arts Paper | ZeeLin Academic Paper |
|------|--------------------------|----------------------|
| **适用学科** | 文科/社科 | 理工科 |
| **论证特点** | 理论分析、思辨性 | 研究假设、实验设计 |
| **对策章节** | 对策建议（政策导向） | 结果分析（数据导向） |
| **语言风格** | 理论深度、思辨性 | 严谨性、可验证性 |

## ⚠️ 学术诚信提醒

**重要**：
- 本工具生成的内容**仅供参考和启发**
- 用户需对最终论文内容负责
- 必须引用所有参考文献来源
- 不得抄袭或伪造观点
- 建议人工审阅和修改生成内容

## 🛠️ 使用建议

### 提高生成质量的技巧

1. **提供高质量参考文献** - 参考文献质量直接影响生成质量
2. **详细的研究背景** - 背景越详细，生成内容越精准
3. **逐步确认** - 每个章节生成后及时确认，避免后续大幅修改
4. **人工润色** - 生成后建议人工审阅、补充理论深度和案例

### 理论深化建议

- **补充理论分析** - 增加经典理论的引用和分析
- **加强思辨性** - 提出批判性观点和独到见解
- **案例支撑** - 补充具体案例增强说服力
- **数据支撑** - 适当引用调查数据或统计资料

## 📊 版本历史

### v1.0.0 (2026-03-04)
- 🎉 初始版本发布
- ✨ 支持全流程论文生成
- 🛠️ 可自定义章节数量
- 📝 强调理论深度和思辨性

## 🤝 贡献

欢迎提交问题和建议！

- **Issues**: [ClawHub 技能页面](https://clawhub.ai/skills/zeelin-liberal-arts-paper)
- **Email**: 通过项目主页联系
- **讨论**: OpenClaw Discord 社区

## 📄 许可证

MIT License - 详见 [LICENSE](LICENSE)

## 👤 作者

**刘东江** (@lidngjing317853)

- 项目主页: https://melodylab.top
- ClawHub: [@dongjiangliu9-tech](https://clawhub.ai/users/dongjiangliu9-tech)

## 🙏 致谢

感谢 [OpenClaw](https://openclaw.ai/) 提供优秀的 AI 代理平台。

---

**免责声明**: 本工具仅供学习和研究辅助使用。用户需遵守学术诚信规范，对最终论文内容负责。不得用于学术不端行为。
