---
name: auto-ppt
description: 根据用户提供的主题、观点或文本，通过 Google NotebookLM 在浏览器中自动生成演示文稿，导出为 PDF 保存到桌面。白底黑字，逻辑清晰，不出现中文幻觉。
---

# Auto-PPT — 通过 NotebookLM 自动生成演示文稿

## 概述

这个 Skill 让你（OpenClaw Agent）能够：

1. 根据用户提供的 **主题 / 观点 / 一段话**，用大模型整理成一篇 **结构化文章**
2. 通过浏览器打开 **Google NotebookLM**，将文章导入
3. 让 NotebookLM 生成演示文稿（slides）
4. **导出为 PDF**，保存到用户桌面（`~/Desktop/`）

## 何时触发

当用户出现以下意图时使用本 Skill：

- 「帮我做 PPT」「生成演示文稿」「做个 slides」
- 「把这段话变成 PPT」
- 「围绕 XXX 主题做一个报告」
- 「帮我做一个 PDF 演示」
- 「用 NotebookLM 帮我做 PPT」

## 前置假设

- 用户已在浏览器中登录 Google 账号（NotebookLM 需要 Google 账号）
- Gateway 已启用 `browser`（openclaw-managed 或 chrome profile 均可）
- 可正常访问 `https://notebooklm.google.com`

---

## 总体流程

### Step 1：整理内容为结构化文章

用户可能给出：
- **完整文章**：直接使用
- **一段话 / 几个观点**：帮用户扩展成结构化文章（800-2000 字）
- **一个主题**：自行调研并组织内容

无论哪种输入，最终产出一篇 **结构清晰的 Markdown 文章**，包含：
- 标题
- 3～8 个章节，每章节有小标题和 3-5 个要点
- 总结

**内容要求：**
- 不要出现中文幻觉：所有内容必须基于用户输入或可验证的事实，不得编造数据或引用
- 逻辑清晰，层次分明
- 每个要点简洁（一句话说清）

将文章写入临时文件：

```bash
cat > /tmp/ppt_content.md << 'EOF'
# 演示标题

## 第一章：xxx
- 要点一
- 要点二
- 要点三

## 第二章：xxx
...

## 总结
...
EOF
```

### Step 2：打开 NotebookLM 并创建笔记本

1. 用 `browser` 工具打开 `https://notebooklm.google.com`
2. 等待页面加载完成

3. **处理登录**：
   - 如果页面要求登录 Google 账号，停止操作
   - 提示用户：「请在浏览器中登录 Google 账号，完成后回复『已登录』」
   - 收到确认后继续

4. 点击 **「New notebook」** 或 **「新建笔记本」** 按钮创建新笔记本

### Step 3：导入内容到 NotebookLM

1. 在新笔记本中，找到添加来源（Add source）的入口
2. 选择 **「Paste text」**（粘贴文本）或 **「Copy and paste text」**
3. 将 Step 1 准备好的文章内容完整粘贴到输入框
4. 确认添加

### Step 4：生成演示文稿

1. 内容导入成功后，在 NotebookLM 的界面中寻找：
   - 右侧面板或底部工具栏中的 **「Audio Overview」** 区域附近
   - 或在笔记本操作菜单中找到 **生成 / Create** 相关选项
   - 寻找 **「Briefing doc」「Study guide」「Slides」「Presentation」** 等选项
2. 点击生成 slides / presentation 的选项
3. 等待 NotebookLM 生成完成（通常需要 10-30 秒）

如果没有直接的 slides 生成选项：
- 在笔记区域（notes）中输入提示：「请将上述内容整理成一个演示文稿大纲，每页包含标题和 3-5 个要点」
- 或使用 NotebookLM 的 chat 功能请求生成 slides 格式的内容

### Step 5：导出为 PDF

NotebookLM 生成的内容需要导出为 PDF：

**方法 A — NotebookLM 原生导出（优先）**：
1. 如果 NotebookLM 提供了 slides 视图，寻找 **下载 / Export / 导出** 按钮
2. 选择 PDF 格式
3. 下载文件

**方法 B — 通过 Google Slides 导出**：
1. 如果 NotebookLM 将内容导出到 Google Slides，在 Google Slides 中：
   - 点击菜单 **File → Download → PDF Document (.pdf)**
   - 或 **文件 → 下载 → PDF 文档 (.pdf)**
2. 文件会下载到浏览器默认下载目录

**方法 C — 浏览器打印为 PDF（兜底）**：
1. 在 slides 页面使用键盘快捷键 `Cmd+P` 触发打印
2. 在打印对话框中选择 **「Save as PDF」/ 「另存为 PDF」**
3. 选择保存位置为桌面

### Step 6：保存到桌面

如果 PDF 下载到了默认下载文件夹（通常是 `~/Downloads/`），移动到桌面：

```bash
# 找到最新下载的 PDF
latest_pdf=$(ls -t ~/Downloads/*.pdf 2>/dev/null | head -1)
if [ -n "$latest_pdf" ]; then
    cp "$latest_pdf" ~/Desktop/
    echo "PDF saved to: ~/Desktop/$(basename "$latest_pdf")"
fi
```

或者直接重命名并移动：

```bash
mv ~/Downloads/NotebookLM_*.pdf ~/Desktop/演示文稿_$(date +%Y%m%d).pdf
```

### Step 7：向用户汇报

告诉用户：
- PDF 保存位置（`~/Desktop/xxx.pdf`）
- 内容概要（共几页，覆盖了哪些章节）
- 如果某个步骤失败，说明原因和替代方案

---

## 设计偏好（告知 NotebookLM 或自行排版时参考）

| 项目 | 规范 |
|------|------|
| 标题字体 | 微软雅黑或系统默认无衬线体，大号加粗 |
| 标题对齐 | 左上角对齐 |
| 背景 | 纯白底 |
| 文字颜色 | 黑色（标题）/ 深灰（正文）|
| 逻辑 | 清晰，不要前后矛盾 |
| 内容 | 不要编造数据，不要出现中文幻觉 |
| 每页要点 | 3～5 个，简洁 |

---

## 安全与注意事项

- **Google 账号**：不要尝试输入用户的 Google 密码，遇到登录页面必须停止并提示用户手动登录
- **内容安全**：不要上传用户明确标记为机密的内容到 NotebookLM
- **网络要求**：需要能访问 Google 服务

---

## 备用方案：本地 Python 生成

如果无法访问 NotebookLM（网络问题、未登录等），可以回退到本地生成：

```bash
python3 {baseDir}/scripts/make_ppt.py /tmp/slides.json --out ~/Desktop/presentation.pptx --pdf
```

本地脚本需要 `python-pptx`（`pip3 install python-pptx`）和 LibreOffice（`brew install --cask libreoffice`）来转 PDF。

---

## 示例

**用户**：帮我做一个关于「智能媒体传播」的课程讲义 PPT

**你的行为**：
1. 用大模型整理出 6-8 章节的结构化文章，写入 `/tmp/ppt_content.md`
2. 打开浏览器，导航到 `https://notebooklm.google.com`
3. 创建新笔记本，粘贴文章内容
4. 请求 NotebookLM 生成 slides
5. 导出为 PDF
6. 移动到 `~/Desktop/智能媒体传播_课程讲义.pdf`
7. 告诉用户：「PDF 已保存到桌面：智能媒体传播_课程讲义.pdf（共 8 页）」
