# 理工科论文提示词模板

## 1) 通用角色设定

请在接下来的所有写作中严格遵守以下总体要求：
1. 学术化与严谨性：语言必须严谨、精练、学术化，避免口语化与冗余描述。
2. 理论深度与逻辑性：所有论述应具备明确逻辑脉络和因果、递进、归纳或对比关系。
3. 创新性与思辨性：注重理论创新与方法创新，提出新问题、新视角并展开论证。
4. 时代意义与实践关联：体现现实关联，为理论与实践发展提供可用启示。
5. 整体风格统一：研究方向、框架、引言、综述、论证、结果分析、结论、摘要、关键词风格统一，不使用 Markdown。

## 2) 题目生成模板

基于参考文献题目提出研究题目，要求：
1. 与参考文献和综述背景紧密相关。
2. 具备创新性并可填补研究空白。
3. 学术价值高，具备理论拓展潜力。

输入：`{参考文献}`

返回要求：
1. 仅返回中文题目，不含其他说明。
2. 不含“题目”字样。
3. 不含星号、引号、书名号、特殊符号和换行。

## 3) 大纲生成模板

输入：
- 标题：`{题目}`
- 简要综述：`{综述}`

约束：
1. 标准结构：一、引言；二、综述；三、论证；四、建议；五、结论。
2. 综述提炼主要研究问题。
3. 论证包含 `{论证数}` 小节。
4. 建议包含 `{建议数}` 个对策建议。

输出 JSON：
```json
{
  "引言": "用一句话简单概括全文引言",
  "综述": [{"zs": "主要研究问题的小标题"}],
  "论证": [{"lz": "论证小标题"}],
  "建议": [{"jy": "具体建议或策略的小标题"}],
  "结论": "用一句话概括全文研究结论"
}
```

## 4) 引言模板

输入：`{题目}` `{框架}`

要求：
1. 标题“一、引言”，500-800 字，两个自然段，不引文。
2. 第一段：政策背景与选题意义。
3. 第二段：研究问题与创新贡献。
4. 结尾固定句式：“本文面向……对象，基于……理论，利用……方法，以期实现……目的。”

## 5) 综述收束段（研究流程）模板

输入：`{题目}` `{框架}` `{引言}` `{综述}`

要求：
1. 开头点明需解决的问题数量。
2. 按“首先/其次/然后/最后”写研究路径：
- 首先：数据或对象与分析任务。
- 其次：研究方法与解决方案设计。
- 然后：关键发现（排比、对称表达）。
- 最后：创新点（排比、对称表达）。

## 6) 论证模板（理工科重点）

输入：`{题目}` `{框架}` `{引言}` `{综述}`

总要求：
1. 标题“三、论证”，分 3 个层次：`3.1` 理论框架，`3.2` 研究问题与假设，`3.3` 研究设计。
2. 三个层次前写总括段（>500字）。
3. 每层内部自然成段、深度展开，强调引言中的理论基础。

### 3.1 理论框架
- 第一段（>800字）：框架作用、来源、核心组成与关系。
- 第二段（>800字）：核心理论/模型与适用性，整合逻辑。
- 第三段（>800字）：整体结构、变量关系、创新性、实践价值与可扩展性。

### 3.2 研究问题与假设
- 第一段（>1000字）：从背景到研究空白，提出研究问题（问题单独成段）。
- 第二段（>1000字）：从理论框架推导假设，逐条说明依据与可检验性。
- 第三段（>800字）：总结学术、实践、方法论意义。

### 3.3 研究设计
- 第一段（>1000字）：研究方法与设计逻辑，说明适配性与创新点。
- 第二段（>1000字）：数据来源与样本选择，需给出模拟数据与表格信息（变量、样本、来源假设）。
- 第三段（>1000字）：分析工具与技术支持（SPSS/R/Python/Nvivo 等）及其优势。

## 7) 结果分析模板

输入：`{题目}` `{框架}` `{引言}` `{论证}`

要求：
- 第一段（>800字）：数据处理流程与分析方法选择依据。
- 第二段（>800字）：结果呈现与初步分析（可含图表说明）。
- 第三段（>800字）：深入分析并与理论框架对接。
- 第四段（>800字）：局限性与改进方向。
- 结尾段（>500字）：整体价值与贡献总结。

## 8) 结论模板

输入：`{题目}` `{框架}` `{引言}` `{综述}` `{论证}` `{对策建议}`

要求：
1. 标题“五、结论”，一个自然段，小于 400 字。
2. 第一句总结研究重点与主要结论。
3. 第二句提出未来研究方向。
4. 第三句升华时代意义与价值。
5. 不引用文献。

## 9) 摘要模板

输入：`{题目}` `{引言}` `{综述}` `{论证}` `{对策建议}` `{结论}`

要求：
1. 不使用标题。
2. 包含研究目的、方法、结果、结论。
3. 一个自然段，100-400 字，不引用文献。

## 10) 关键词模板

输入：`{题目}` `{摘要}` `{关键词数}`

输出格式：
`关键词：XX；XX；XX`
并尽量使用核心概念术语。
