---
name: ZeeLin Academic Paper
slug: zeelin-academic-paper
version: 1.0.1
description: 高校硕博研究生必备，理工科论文 AI 全流程创作助手：自动生成论文标题、大纲、引言、综述、论证、结果分析和结论，保持学术严谨性和逻辑一致性，支持自定义章节数量 - Powered by ZeeLin
author: 刘东江 (@lidngjing317853)
license: MIT
homepage: https://melodylab.top
tags: [academic, paper, research, stem, chinese, writing, zeelin]
requires:
  - capability: file-system
---

## 📋 隐私与透明度

**本地处理**: 
- 所有论文生成过程在本地完成
- 不上传用户的论文内容、参考文献或研究数据到任何服务器
- 不收集任何个人信息或研究数据

**数据安全**: 
- ✅ 完全本地化运行
- ✅ 无外部 API 调用
- ✅ 无数据泄露风险
- ✅ 符合学术保密要求

---

## 使用时机

当用户请求：
- 写理工科论文 / 生成学术论文
- 生成研究假设与研究设计
- 输出结果分析章节
- 按理工论文模板出文
- 根据参考文献写论文

不适合：
- 文科论文（历史、哲学、文学等）
- 商业报告或市场分析
- 非学术性写作

---

## 核心功能

### 🎯 全流程自动化

从零开始到完整论文，一站式生成：

1. **智能题目生成**
   - 基于参考文献自动提取研究空白
   - 确保创新性和学术价值
   - 避免重复和低价值选题

2. **结构化大纲设计**
   - 自动生成标准五段式结构（引言、综述、论证、建议、结论）
   - 支持自定义论证数量和建议数量
   - JSON 格式清晰展示逻辑框架

3. **逐章节内容生成**
   - 引言：研究背景、问题陈述、创新点
   - 综述：文献回顾、研究流程
   - 论证：理论框架、研究假设、研究设计
   - 结果分析：数据解读、发现阐释
   - 结论：总结、局限性、未来研究方向
   - 摘要与关键词：提炼核心内容

### ✨ 学术质量保证

- **逻辑一致性检查**：确保方法、假设、结果相互呼应
- **学术化语言**：严谨、精练、避免口语化
- **理论深度**：强调创新性和理论贡献
- **可验证性**：研究假设、数据、方法、结论紧密关联

### 🛠️ 灵活定制

- 自定义论证小节数量（默认 3 个）
- 自定义建议数量（默认 3 个）
- 自定义关键词数量（默认 5 个）
- 支持用户提供题目或自动生成
- 支持纯文本或结构化 JSON 输出

---

## Agent 执行流程

### 第 1 步：收集输入

询问或推断用户需要：

**必需输入**：
- 参考文献列表（至少 1-3 篇）
- 综述材料或研究背景

**可选输入**：
- 论文题目（没有则自动生成）
- 论证数量（默认 3）
- 建议数量（默认 3）
- 关键词数量（默认 5）

**交互示例**：
> "你好！我可以帮你生成理工科论文 📝
> 
> 请提供：
> 1. 参考文献题目或内容（至少 1-3 篇）
> 2. 研究背景或综述材料
> 3. （可选）论文题目、论证数量、建议数量
> 
> 你想研究什么方向？"

### 第 2 步：生成题目（如需要）

如果用户未提供题目，调用题目生成模板：

- 基于参考文献分析研究空白
- 提出创新性研究题目
- 确保学术价值和理论潜力

**示例输出**：
> "基于你的参考文献，我建议的论文题目是：
> 
> **《人工智能辅助的城市交通流量预测模型研究》**
> 
> 满意吗？（回复'确认'或'修改为 XXX'）"

### 第 3 步：生成大纲

调用大纲生成模板，输出 JSON 结构：

```json
{
  "引言": "概述研究背景、问题与创新点",
  "综述": [
    {"zs": "城市交通流量预测研究现状"},
    {"zs": "人工智能在交通预测中的应用"}
  ],
  "论证": [
    {"lz": "基于深度学习的流量预测理论框架"},
    {"lz": "研究假设与变量设定"},
    {"lz": "实验设计与数据采集方案"}
  ],
  "建议": [
    {"jy": "优化城市交通管理策略"},
    {"jy": "推广智能交通系统应用"},
    {"jy": "加强跨学科协作研究"}
  ],
  "结论": "总结研究发现、局限性与未来方向"
}
```

**展示给用户确认**：
> "论文大纲已生成，请查看：
> [显示 JSON 大纲]
> 
> 满意吗？需要调整章节数量或标题吗？"

### 第 4 步：逐章节生成内容

按顺序生成各章节：

1. **引言** → 展示给用户确认
2. **综述收束段与研究流程** → 确认
3. **论证（每个小节逐一生成）** → 确认
4. **结果分析** → 确认
5. **结论** → 确认
6. **摘要与关键词** → 完成

每个章节生成后，询问用户：
> "【引言】章节已生成，请查看：
> [内容]
> 
> 满意吗？（回复'确认'继续下一章，或'修改XXX'）"

### 第 5 步：输出完整论文

将所有章节合并，输出完整论文（纯文本格式，不含 Markdown）：

```
【题目】
人工智能辅助的城市交通流量预测模型研究

【摘要】
本研究基于深度学习技术...

【关键词】
人工智能；交通流量预测；深度学习；...

一、引言
...

二、综述
...

三、论证
（一）基于深度学习的流量预测理论框架
...

四、建议
（一）优化城市交通管理策略
...

五、结论
...
```

---

## 资源使用

**加载模板文件**：
- 读取 `references/prompts_zh.md` 获取所有章节模板
- 直接复用模板中的占位符和约束条件
- 不要重写模板结构

**模板优先级**：
- 如果用户约束与模板约束冲突，优先用户约束并说明调整

**数据生成**：
- 当模板需要模拟数据或表格内容时，生成与主题一致的合成示例
- 确保数据逻辑自洽、符合研究情境

---

## 输出规则

### 学术规范

1. **语言风格**：严谨、精练、学术化，避免口语化
2. **逻辑脉络**：明确因果、递进、归纳或对比关系
3. **创新性**：提出新问题、新视角并展开论证
4. **实践意义**：体现现实关联，提供可用启示
5. **风格统一**：所有章节风格一致，不使用 Markdown

### 格式要求

- 纯文本输出（除非用户指定其他格式）
- 标题层级清晰（一、二、三 / （一）（二）（三））
- 不含特殊符号（星号、引号、书名号等）
- 不含换行冗余

### 质量检查

- 方法一致性：引言中提到的方法必须在论证和结果分析中体现
- 假设-结果对应：研究假设与结果分析紧密关联
- 引用规范：所有论述有据可查（基于参考文献）

---

## 快捷指令示例

- `/paper 基于深度学习的流量预测研究`
- `/paper 根据这 3 篇文献写一篇论文 [文献列表]`
- `/paper 生成研究假设与研究设计`

---

## 注意事项

### 学术诚信

⚠️ **重要提醒**：
- 本工具生成的内容仅供参考和启发
- 用户需对最终论文内容负责
- 必须引用所有参考文献来源
- 不得抄袭或伪造数据
- 建议人工审阅和修改生成内容

### 使用建议

1. **提供高质量参考文献**：参考文献质量直接影响生成质量
2. **逐步确认**：每个章节生成后及时确认，避免后续大幅修改
3. **人工润色**：生成后建议人工审阅、补充细节和调整表述
4. **数据真实性**：如需真实数据，请替换生成的模拟数据

---

## 支持与反馈

- **开发者**: 刘东江 (@lidngjing317853)
- **项目主页**: https://melodylab.top
- **问题反馈**: 通过 ClawHub 或项目主页联系

---

## 示例对话流程

**用户**："帮我写一篇关于人工智能在医疗诊断中的应用的论文"

**Agent**：
> "你好！我可以帮你生成理工科论文 📝
> 
> 请提供：
> 1. 参考文献题目或内容（至少 1-3 篇）
> 2. 研究背景或综述材料
> 
> 关于'人工智能在医疗诊断中的应用'，你有哪些参考文献？"

**用户**："文献 1：深度学习在医学影像诊断中的研究进展；文献 2：..."

**Agent**：
1. 生成题目建议
2. 展示大纲 JSON
3. 逐章节生成并确认
4. 输出完整论文

**最终输出**：
> "✅ 论文生成完成！
> 
> [完整论文内容]
> 
> 📝 温馨提示：
> - 请人工审阅并补充细节
> - 记得引用所有参考文献
> - 如需真实数据，请替换模拟数据"
