# ZeeLin Academic Paper 📝

**理工科论文 AI 全流程创作助手** - 从选题到完稿，一站式生成高质量学术论文

[![Version](https://img.shields.io/badge/version-1.0.0-blue.svg)](https://clawhub.ai/skills/zeelin-academic-paper)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE)
[![OpenClaw](https://img.shields.io/badge/OpenClaw-Skill-orange.svg)](https://openclaw.ai)

## ✨ 核心优势

### 🎯 全流程自动化
- **智能题目生成** - 基于参考文献自动提取研究空白
- **结构化大纲设计** - 标准五段式结构，逻辑清晰
- **逐章节内容生成** - 从引言到结论，一站式完成

### ✨ 学术质量保证
- **逻辑一致性检查** - 确保方法、假设、结果相互呼应
- **学术化语言** - 严谨、精练、避免口语化
- **理论深度** - 强调创新性和理论贡献
- **可验证性** - 研究假设、数据、方法、结论紧密关联

### 🛠️ 灵活定制
- 自定义论证小节数量（默认 3 个）
- 自定义建议数量（默认 3 个）
- 自定义关键词数量（默认 5 个）
- 支持纯文本或 JSON 格式输出

### 🔒 完全本地化
- **无数据上传** - 所有处理在本地完成
- **无隐私风险** - 不调用任何外部 API
- **符合学术保密要求** - 研究数据完全由你控制

## 🚀 快速开始

### 安装

```bash
# 使用 ClawHub CLI
clawhub install zeelin-academic-paper

# 或者手动克隆
git clone https://github.com/yourusername/zeelin-academic-paper.git ~/.openclaw/workspace/skills/zeelin-academic-paper
```

### 使用示例

**完整流程**:
```
你: 帮我写一篇关于人工智能在医疗诊断中的应用的论文
AI: [询问参考文献和研究背景]
你: [提供 2-3 篇参考文献和简要背景]
AI: [生成题目建议]
你: 确认
AI: [生成大纲 JSON 并展示]
你: 确认
AI: [逐章节生成并等待确认]
你: 确认/修改
AI: [最终输出完整论文]
```

**快捷指令**:
```
/paper 基于深度学习的流量预测研究
/paper 根据这 3 篇文献写一篇论文 [文献列表]
/paper 生成研究假设与研究设计
```

## 📋 生成内容结构

```
【题目】
自动生成或用户提供

【摘要】
提炼研究核心内容

【关键词】
5-8 个关键词

一、引言
- 研究背景
- 问题陈述
- 创新点

二、综述
- 文献回顾
- 研究流程

三、论证
（一）理论框架
（二）研究假设
（三）研究设计
...（支持自定义数量）

四、建议
（一）具体建议 1
（二）具体建议 2
...（支持自定义数量）

五、结论
- 研究总结
- 局限性
- 未来研究方向
```

## 🎓 支持的论文类型

### ✅ 适用场景
- 理工科学术论文（工程、计算机、数学、物理、化学等）
- 研究型论文（实验研究、理论研究、应用研究）
- 中文论文写作

### ❌ 不适用场景
- 文科论文（历史、哲学、文学等）
- 商业报告或市场分析
- 非学术性写作

## ⚠️ 学术诚信提醒

**重要**：
- 本工具生成的内容**仅供参考和启发**
- 用户需对最终论文内容负责
- 必须引用所有参考文献来源
- 不得抄袭或伪造数据
- 建议人工审阅和修改生成内容

## 🛠️ 使用建议

### 提高生成质量的技巧

1. **提供高质量参考文献** - 参考文献质量直接影响生成质量
2. **详细的研究背景** - 背景越详细，生成内容越精准
3. **逐步确认** - 每个章节生成后及时确认，避免后续大幅修改
4. **人工润色** - 生成后建议人工审阅、补充细节和调整表述

### 数据处理建议

- **模拟数据替换** - 如需真实数据，请替换生成的模拟数据
- **引用格式** - 根据期刊要求调整引用格式
- **表格和图表** - 建议手动优化布局和样式

## 📊 版本历史

### v1.0.0 (2026-03-04)
- 🎉 初始版本发布
- ✨ 支持全流程论文生成
- 🛠️ 可自定义章节数量
- 📝 标准学术规范输出

## 🤝 贡献

欢迎提交问题和建议！

- **Issues**: [ClawHub 技能页面](https://clawhub.ai/skills/zeelin-academic-paper)
- **Email**: 通过项目主页联系
- **讨论**: OpenClaw Discord 社区

## 📄 许可证

MIT License - 详见 [LICENSE](LICENSE)

## 👤 作者

**刘东江** (@lidngjing317853)

- 项目主页: https://melodylab.top
- ClawHub: [@dongjiangliu9-tech](https://clawhub.ai/users/dongjiangliu9-tech)

## 🙏 致谢

感谢 [OpenClaw](https://openclaw.ai/) 提供优秀的 AI 代理平台。

---

**免责声明**: 本工具仅供学习和研究辅助使用。用户需遵守学术诚信规范，对最终论文内容负责。不得用于学术不端行为。
