# image-3-4 模板规范

比例：3:4 | 尺寸：900×1200 | 用途：小绿书 / 公众号 / 小红书通用封面

## 渲染命令

```bash
python3 skills/z-card-image/scripts/render_card.py \
  --template image-3-4 \
  --out /tmp/card.png \
  --line1 "OpenClaw" \
  --line2 "有两层" \
  --line3 "model 配置" \
  --highlight "#22a854" \
  --bg "#e6f5ef" \
  --footer "公众号 · 早早集市"
```

## 参数说明

| 参数 | 默认值 | 说明 |
|------|--------|------|
| `--line1` | 空 | 第一行（普通黑色大字）|
| `--line2` | 空 | 第二行（普通黑色大字，空则隐藏）|
| `--line3` | 空 | 第三行（高亮色大字，空则隐藏）|
| `--highlight` | `#22a854` | 高亮/强调色 |
| `--bg` | `#e6f5ef` | 背景色 |
| `--footer` | `公众号 · 早早集市` | 底部文字 |

## 字数上限

| 位置 | 最多字数 | 说明 |
|------|---------|------|
| 每行（line1/2/3） | **6~7 个汉字** / **10~12 个英文字符** | 字号 108px，可用宽 720px |
| 三行合计 | **≤ 20 字** | 超出则横向溢出，无法使用 |

> 用户文案超出时，先帮忙拆分/缩写到上限内，再渲染，不要直接塞入模板。

## 配图选取原则

| 条件 | 使用图标 | 文件 |
|------|---------|------|
| 任意行含 `openclaw`（不区分大小写） | OpenClaw 小龙虾 | `assets/icons/openclaw-logo.svg` |
| 其他（默认） | 博客站 logo（灰色） | `assets/icons/zzclub-logo-gray.svg` |
