# article-3-4 模板规范

## 模板信息

- 比例：3:4
- 尺寸：900 × 1200px
- 用途：长文章分页卡片，适合公众号/小红书多图传播

## LLM 分段公式

使用此模板前，**LLM 需先自行计算分页**，不依赖脚本机械切分。

### 容量估算

```
内容区有效高度 ≈ 1200 - 顶栏100 - 分割线50 - 底栏80 - 上下padding120 = 850px

字号：30px
行高：1.85 → 每行实际高度 ≈ 30 × 1.85 = 55px
内容区有效宽度 = 900 - 左右padding144 = 756px

每行可放中文字符 ≈ 756 / 30 = 25 个
每页可放行数 ≈ 850 / 55 = 15 行
每页中文字符容量 ≈ 25 × 15 = 375 字

英文字符宽度约为中文的 0.5，折算：2 英文字符 ≈ 1 中文字符
段落间距约消耗 24px ≈ 0.5 行，每个段落边界扣 0.5 行
```

### LLM 分段步骤

1. 统计全文总中文当量字符数（英文/数字按 0.5 折算）
2. 计算估算页数 = ceil(总字符数 / 340)（预留 10% 余量给段落间距）
3. 按**语义边界**切分，优先在段落结尾处分页，不截断句子
4. 每页内容整理成纯文本（段落间空行分隔）
5. 将各页文本按顺序传入脚本，脚本负责渲染

### 示例

全文 800 中文当量字符 → 估算 ceil(800/340) = 3 页 → 按语义切成 3 段

## 脚本参数

```bash
python3 render_article.py \
  --title "文章标题" \
  --text "该页正文内容（纯文本，段落间空行分隔）" \
  --page-num 1 \
  --page-total 3 \
  --out /path/to/workspace/tmp/card_01.png \
  [--highlight "#22a854"] \
  [--bg "#e6f5ef"] \
  [--footer "公众号 · 早早集市"]
```

> 注意：LLM 调用时每页单独调用一次脚本，传入该页文本和对应页码。

## 字数上限

每页建议不超过 340 中文当量字符（脚本实际执行时取 90% = 306 字作为安全上限，宁少勿多）。

脚本分段规则（无需 LLM 介入）：
1. 优先在段落边界处分页
2. 段落过长时，在句子结束符（。！？…）处截断
3. 找不到句末符，退而在逗号/分号处截
4. 实在没有分隔符，截到安全上限的 85%

## 水印/底栏

- 默认：`公众号 · 早早集市`
- 小红书：`小红书 · 阿康`
- 非最后一页自动显示「← 滑动查看更多」
- 最后一页显示「· 全文完」
