---
name: z-card-image
version: 1.0.4
description: 文字卡片配图生成器（文字→单张 PNG）。触发词：配图、生成图、做张图、卡片图、封面图、小绿书配图、文字图、图片封面、card image、帮我做图、出一张图。
---

# z-card-image

将用户提供的文案渲染成单张 PNG 卡片图，通过 message 工具发图。
长文多图请使用 `z-article-card` skill。

## 环境要求

- Python 3
- Google Chrome（macOS：`/Applications/Google Chrome.app`；Linux：`chromium` 需修改脚本路径）

## 执行流程

0. **环境提示**（用户触发时检测一次，有问题给提示，不中止流程）：
   - `python3 --version` → 失败则告知：「⚠️ 未检测到 Python 3，渲染可能失败」
   - 检查 Chrome 路径 → 失败则提示安装

1. **识别比例**：从用户描述中提取目标比例（如 3:4、16:9）
2. **查模板规则**：根据比例在「模板索引」中找到对应规范文档，读取后按其规则处理文案和参数
3. **识别平台**：按「平台预设」自动设置配色
4. **渲染输出**：执行 `render_card.py`，输出到 `workspace/tmp/card.png`
5. **发图**：用 message 工具，`filePath` 指向输出 PNG，不能用 `/tmp/`（飞书无法上传）

## 输入校验

- **比例不存在**：驳回请求，告知当前支持的比例列表，询问是否新增模板
- **文案超出模板字数上限**：先自动拆分/缩写后再渲染，不要直接塞入

## 平台预设

| 平台 | `--footer` | `--bg` | `--highlight` |
|------|-----------|--------|--------------|
| 公众号（默认） | `公众号 · 早早集市` | `#e6f5ef` | `#22a854` |
| 小红书 | `小红书 · 阿康` | `#fdecea` | `#e53935` |

> 用户提到"小红书配图"时使用小红书预设；否则默认公众号。

## 模板索引

| 模板名 | 比例 | 尺寸 | 用途 | 规范文档 |
|--------|------|------|------|---------|
| `poster-3-4` | 3:4 | 900×1200 | 文字海报（金句/大字报/封面） | [references/image-3-4.md](references/image-3-4.md) |

## 新增模板

1. 新建 `assets/templates/<name>.html`
2. 在 `render_card.py` 的 `size_map` 里注册尺寸
3. 在上方模板索引中添加一行
4. 创建对应 `references/<name>.md`，记录该模板的参数、字数上限、配图选取规则
