# 游戏王日版新闻每日总结 Skill

自动每天早上10点搜索并总结前一天的游戏王日版新闻。

## 功能

- 每天早上 10:00（北京时间）自动执行
- 搜索游戏王日版新闻（新卡情报、规则更新、赛事信息、产品发售）
- 生成中文总结并推送到当前对话

## 安装

```bash
# 创建 skill 目录
mkdir -p /root/.openclaw/skills/yugioh-news

# 复制本文件到 skill 目录
cp SKILL.md /root/.openclaw/skills/yugioh-news/
```

## 使用

### 方式一：直接创建 Cron 任务

```bash
openclaw cron add --name "游戏王日版新闻每日总结" \
  --schedule "0 10 * * *" \
  --timezone "Asia/Shanghai" \
  --prompt "今天是2026年。总结一下昨天的游戏王日版新闻（2026年的日期），包括新卡情报、规则更新、赛事信息、产品发售等主要内容。请用中文总结，格式清晰易读，并确保使用正确的2026年日期。"
```

### 方式二：通过 Agent 创建

发送消息给 Agent：

> 帮我创建一个每天早上10点的定时任务，总结昨天的游戏王日版新闻。

## 配置说明

| 配置项 | 值 | 说明 |
|--------|-----|------|
| 执行时间 | 0 10 * * * | 每天早上10点 |
| 时区 | Asia/Shanghai | 北京时间 |
| 搜索范围 | 游戏王日版新闻 | 新卡、规则、赛事、产品 |
| 输出语言 | 中文 | 带emoji格式 |

## 示例输出

```
# 游戏王日版新闻总结（2026年2月22日）

## 📅 日期：2026年2月22日（周日）

## 一、新卡情报
- LIMIT OVER COLLECTION -THE HEROES- 新卡公开
- ...

## 二、产品发售信息
- ...

## 三、赛事信息
- ...
```

## 注意事项

- 确保当前对话渠道支持消息推送
- 如遇搜索不到新闻的情况，会返回"昨日无重大新闻"
- 日期会自动根据执行时间计算"昨天"

## 作者

Kimi Claw

## 版本

1.0.0
