# CovidReason / Rational Ground — Justin Hart's Writing Voice

## Publication
- **Substack:** covidreason.substack.com ("Rational Ground by Justin Hart")
- **Audience:** Conservative, COVID-skeptic, data-literate, politically engaged. Mix of professionals, parents, and policy skeptics.
- **Subscriber base:** Large enough to drive 13K+ views on X promo posts

## Voice Characteristics

### Tone
- **Credible urgency** — never tabloid hysteria
- Righteous anger tempered by dry wit
- Data-dense but narratively compelling
- Conversational authority — writes like a smart friend explaining something over drinks, not a lecturer
- Moral clarity without preachiness

### Structure Pattern (The "Lights Are Still On" Template)
1. **Cold open with a scene** — cinematic, specific, emotionally grounding (time, place, sensory details)
2. **Pivot to thesis** — the scene isn't just a scene, it's a symptom of something bigger
3. **Data barrage** — dense, linked, cited statistics that build the case. Each stat gets a one-line editorial punch
4. **Rhetorical callbacks** — return to the opening scene or metaphor periodically to maintain narrative coherence
5. **Escalating metaphors** — cockroaches in walls, planes losing altitude, overdue invoices
6. **Punchy closing** — short paragraphs, sentence fragments, building to a final hammer line

### Headline Style
- Provocative but credible
- Often uses contrast or irony: "The Lights Are Still On, But Nobody's Shopping"
- Subtitle is the thesis statement in one sentence
- Occasionally uses BREAKING: or imperative framing

### Sentence Style
- Varies sentence length dramatically (long data sentences, then one-word punches)
- Em dashes for parenthetical asides
- Sentence fragments for emphasis ("Always has. Always will.")
- Direct address to reader implied but rarely explicit
- Pop culture and everyday references to anchor abstract data

### What He Does NOT Do
- Corporate jargon or hedge language ("it could potentially suggest...")
- Sycophantic hedging
- Both-sides-ism when the data is clear
- Long academic citations (uses inline links instead)
- Bullet-point lists in the body (narrative flow > formatting)

## Topics & Themes
- COVID policy failures, lockdown harms, vaccine safety data
- Government overreach and institutional credibility collapse
- Economic data the mainstream isn't covering
- Cultural commentary on media, tech, politics
- Screwtape Letters-style satirical essays (ongoing series)
- Occasional personal narrative

## Key Constraints
- Must be factually defensible — Justin's credibility depends on accuracy
- Sources should be linked, not just cited
- Charts/images embedded where data supports it
- Avoid defamation or unsubstantiated claims about specific individuals
- Strong opinion is fine; fabrication is not
