---
name: yt-dlp
description: A robust CLI wrapper for yt-dlp to download videos, playlists, and audio from YouTube and thousands of other sites. Supports format selection, quality control, metadata embedding, and cookie authentication.
---

# yt-dlp Skill

## Overview
This skill provides a convenient interface to `yt-dlp`, a powerful command-line media downloader. It simplifies the process of downloading videos, extracting audio, and managing playlists with optimal quality settings and metadata handling.

## Usage
- **Role**: Media Archivist.
- **Trigger**: "Download this video", "Get MP3 from YouTube", "Archive this channel".
- **Output**: Downloaded media files in the current directory or specified output path.

## Dependencies
- `yt-dlp`: The core downloader (must be installed in PATH).
- `ffmpeg`: Required for merging video+audio streams and format conversion.

## Commands

### `scripts/download.sh`
The primary entry point. It wraps `yt-dlp` with sensible defaults for high-quality archiving.

**Syntax:**
```bash
./scripts/download.sh <URL> [OPTIONS]
```

**Defaults:**
- Best video + best audio merged (`bv+ba/b`)
- Embeds metadata, thumbnail, and subtitles (`--embed-metadata`, `--embed-thumbnail`, `--embed-subs`)
- Output format: `Title [ID].mp4` (`%(title)s [%(id)s].%(ext)s`)

**Examples:**

1.  **Download a single video (best quality):**
    ```bash
    scripts/download.sh "https://www.youtube.com/watch?v=dQw4w9WgXcQ"
    ```

2.  **Download a playlist:**
    ```bash
    scripts/download.sh "https://www.youtube.com/playlist?list=PL..."
    ```

3.  **Extract Audio (MP3):**
    ```bash
    scripts/download.sh "URL" -x --audio-format mp3
    ```

4.  **Download specific resolution (e.g., 1080p):**
    ```bash
    scripts/download.sh "URL" -f "bv*[height<=1080]+ba/b[height<=1080]"
    ```

5.  **Use Cookies (for age-restricted/premium content):**
    *Note: Requires browser cookies exported to a file or accessed directly.*
    ```bash
    scripts/download.sh "URL" --cookies-from-browser chrome
    ```

## Installation & Security
This skill relies on `yt-dlp` and `ffmpeg` being installed on the host system.
- **Official Sources Only**: Install via `pip install yt-dlp` or your system package manager (`apt`, `brew`). Avoid running curl scripts from untrusted sources.
- **Cookies**: Use `--cookies-from-browser` with caution. For autonomous agents, prefer exporting a `cookies.txt` file manually to limit access to your active browser session.

## Reference Guide
For advanced usage, see the comprehensive [Usage Guide](references/guide.md).
