# Output format

Use this format when returning a video summary to the user.

## Preferred structure (Markdown)

```md
# <Video Title>

> [Watch on YouTube](<canonical_url>) | Duration: <MM:SS> | Published: <YYYY-MM-DD>

## Summary
<1 dense paragraph (5-9 sentences) covering: context, setup/use, measurements, comparison, conclusion>

## Chapters
### <Chapter 1 title>
- <fact-based bullet>
- <fact-based bullet>

### <Chapter 2 title>
- <fact-based bullet>
- <fact-based bullet>

## Key Takeaways
- <practical takeaway>
- <practical takeaway>
- <practical takeaway>
```

## Section rules

- **Summary**: write one compact narrative paragraph, not fragmented mini-bullets.
- **Chapters**: chronological sections with short headings; each section should have 2-4 bullets.
- **Key Takeaways**: 6-10 bullets, practical and decision-oriented.
- Keep numbers/units explicit when present (price, speed, ping, watts, distance, dates).

## Source-policy-aware usage

- **Full mode succeeded**: treat youtube2md Markdown output (`.md`) as canonical and use it directly.
- **Non-full mode (extract)**: summarize from prepared transcript text (`.txt`) generated by `prepare.py`.

## File path visibility

- By default, do **not** include local generated file paths (`.md/.json/.txt`) in user-facing summary messages.
- Include file paths only when the user explicitly asks for them.
