# Sample Output

## Example 1: AI Productivity Video

**Input:** `https://youtu.be/EZ4EjJ0iDDQ`

**Output:**

```
📹 **Video:** THE MISTAKE COSTING YOU 40% IN PRODUCTIVITY - Stop Teaching AI Basics
👤 **Channel:** AI News & Strategy Daily | 👁️ **Views:** 22.2k | 📅 **Published:** 2025-12-03

**🎯 Main Thesis:**
Most AI training focuses on the wrong layer—either basic "101" prompting or advanced "401" technical implementation. The missing middle ("201 level") is where actual productivity gains happen, and it requires management skills, not tool skills.

**💡 Key Insights:**
- Microsoft study of 300K employees showed 80% stopped using AI after initial excitement crater; survivors treated AI as a management skill, not a tool skill
- The "201 level" gap includes six critical skills: context assembly, quality judgment, task decomposition, iterative refinement, workflow integration, and frontier recognition
- BCG/Harvard study found consultants were 19% less accurate on tasks outside AI's capability frontier, showing the danger of applying one mental model without understanding boundaries
- Two effective work patterns emerged: "Centaur mode" (clearly divided tasks) for high-stakes work, and "Cyborg mode" (fluid integration) for creative work
- The apprentice model is collapsing—juniors miss routine work that builds judgment, creating a long-term expertise deficit

**📝 Notable Points:**
- Token consumption leaderboards at major orgs are dominated by senior execs and distinguished engineers—not because of technical skill, but management capability and domain knowledge
- Organizations need experts mapping the frontier and creating guardrails, while enabling non-experts to work safely within those boundaries
- Fear of doing it wrong is the biggest adoption blocker—without clear organizational guidance, talented people see AI as risk and avoid it
- Employees who receive more than 5 hours of formal AI training are double-digit percentage points more likely to become regular users

**🔑 Takeaway:**
Getting 80% of your organization to "201 level" AI fluency—treating AI like a capable but inexperienced collaborator who needs management—distinguishes companies that realize real gains from those stuck with a few power users and mass disengagement. Invest in the judgment layer, not just tool deployment.
```

**File saved:** `/root/clawd/transcripts/2026-01-26_EZ4EjJ0iDDQ.txt`

---

## Example 2: Short Tutorial Video

**Input:** `https://youtu.be/dQw4w9WgXcQ`

**Output:**

```
📹 **Video:** How to Build a REST API in 10 Minutes
👤 **Channel:** DevTips | 👁️ **Views:** 450k | 📅 **Published:** 2024-08-15

**🎯 Main Thesis:**
You can build a production-ready REST API quickly using modern frameworks and best practices without overengineering.

**💡 Key Insights:**
- Express.js with TypeScript provides type safety and rapid development
- Middleware pattern handles authentication, validation, and error handling cleanly
- Environment variables manage configuration across dev, staging, and production
- Simple folder structure (routes, controllers, services) scales better than complex architectures

**📝 Notable Points:**
- Use Zod for runtime validation instead of manual checks
- Prisma ORM eliminates SQL boilerplate while maintaining type safety
- Docker containerization ensures consistency across environments

**🔑 Takeaway:**
Start simple with proven patterns, add complexity only when needed, and prioritize developer experience to ship faster.
```

**File saved:** `/root/clawd/transcripts/2024-08-15_dQw4w9WgXcQ.txt`

---

## Platform-Specific Behavior

### Telegram
- Summary sent as text message
- Full transcript sent as `.txt` file attachment
- Caption on file: "📄 YouTube Transcript: [Video Title]"

### Webchat / Discord / Other
- Summary sent as text message
- Transcript saved locally but not sent as file
- User informed of save location

---

## Transcript File Format

```
VIDEO: THE MISTAKE COSTING YOU 40% IN PRODUCTIVITY - Stop Teaching AI Basics
URL: https://youtu.be/EZ4EjJ0iDDQ
Channel: AI News & Strategy Daily
Views: 22.2k
Published: 2025-12-03

=== TRANSCRIPT ===

Toward the very end of 2025, a study happened that we didn't pay attention to. Microsoft tracked 300,000 employees using AI C-Pilot. Excitement peaked for the first three weeks. Then there was a crater of disappointment...

[full transcript continues...]
```
