---
name: youtube-playlists
description: Create and manage YouTube playlists. Use when user wants to create a playlist, add videos to playlists, or manage their YouTube playlists.
metadata: {"openclaw":{"emoji":"📋","requires":{"bins":["python3"]}}}
---

# YouTube Playlists

Create and manage YouTube playlists via OAuth.

## Commands

```bash
# Authenticate (first time only)
python3 {baseDir}/scripts/yt_playlist.py auth

# Create empty playlist
python3 {baseDir}/scripts/yt_playlist.py create "Playlist Name"

# Add video to existing playlist  
python3 {baseDir}/scripts/yt_playlist.py add <playlist_id> <video_id_or_url>

# Create playlist with multiple videos (best for agent use)
python3 {baseDir}/scripts/yt_playlist.py bulk-create "Playlist Name" <video1> <video2> ...

# List your playlists
python3 {baseDir}/scripts/yt_playlist.py list
```

## Examples

Create a Zwift watchlist:
```bash
python3 {baseDir}/scripts/yt_playlist.py bulk-create "Zwift Feb 3" \
  l3u_FAv33G0 \
  MY5omSLtAvk \
  VdaZqfEKv38 \
  Wq16lyNpmYs \
  SE7d4eaOJv4
```

## Notes
- First run requires browser auth (opens automatically)
- Token is cached in `token.pickle` 
- Accepts video IDs or full YouTube URLs
- Default privacy is "unlisted" for bulk-create, "private" for single create
