# 🎬 YouTube-Hook

[![ClawHub](https://img.shields.io/badge/ClawHub-available-brightgreen)](https://clawhub.ai/skills/youtube-hook)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

**YouTube-Hook** is an OpenClaw skill that generates complete, production-ready YouTube video packages from any topic, article, or product. Used by creators to cut video planning from 3 hours to 10 minutes.

## ✨ Features

- **3 Click-Optimized Titles** – Curiosity + keyword balance for maximum CTR
- **Thumbnail Brief** – Visual strategy with background, focal element, text, emotion, and color contrast
- **Full Script with Timestamps** – Spoken language, [B-ROLL] markers, pattern interrupts
- **Chapter Markers** – SEO-boosting timestamps ready to paste
- **Video Description** – Hook + summary + links + hashtags
- **Tags & SEO Keywords** – Broad + niche + long-tail phrases
- **Upload Strategy** – Best times, community posts, pinned comments, Shorts ideas
- **Tone Selection** – Educational, entertaining, controversial, professional, storytelling

## 📋 What's Included

```text
├── SKILL.md # The skill (main instructions + frontmatter)
├── README.md # This file
├── scripts/
│ ├── hook_generator.py # Generates platform-specific hooks
│ ├── trend_analyzer.py # (Optional) Tavily integration for trends
│ └── title_optimizer.py # Title generation with CTR patterns
└── examples/
└── silver-investing.md # Complete example output
```