# ClawHub - YouTube Video Clipper & Downloader

Extract specific sections from YouTube videos with precise timestamps. A powerful ClawHub skill that makes video clipping effortless - just provide a URL and time range.

## Overview

ClawHub is designed primarily for **video clipping** - extracting specific time ranges from YouTube videos. Whether you need a 30-second highlight, a 5-minute tutorial segment, or any custom time range, ClawHub handles it with precision. It also supports full video downloads, audio extraction, and quality selection when needed.

## Key Features

### Primary: Video Clipping
- **Precise Timestamp-Based Clipping**: Extract any time range (MM:SS or HH:MM:SS)
- **Quality Selection**: Clip in 720p, 1080p, or best available
- **Audio Clipping**: Extract audio clips as MP3
- **Fast Processing**: Optimized for quick clip extraction

### Secondary: Full Downloads
- Download complete videos in various qualities
- Extract full audio tracks
- Custom output filenames and formats

## Usage

### Basic Syntax
```
/clawhub <youtube-url> [options]
```

## Clipping Examples (Primary Use)

### Clip a specific section
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --clip 00:30-02:15
```
Extracts from 30 seconds to 2 minutes 15 seconds.

### Clip with quality selection
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --clip 01:00-03:30 --quality 1080p
```
Extracts a 1080p clip from 1 minute to 3 minutes 30 seconds.

### Clip audio only
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --clip 00:10-01:00 --audio-only
```
Extracts audio from 10 seconds to 1 minute as MP3.

### Clip with custom filename
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --clip 02:00-04:30 --output highlight.mp4
```

### Clip tutorial section
```
/clawhub https://youtube.com/watch?v=tutorial123 --clip 05:20-12:45 --quality 720p
```
Perfect for extracting specific tutorial steps.

### Clip music section
```
/clawhub https://youtube.com/watch?v=music456 --clip 01:15-02:30 --audio-only --output chorus.mp3
```

## Download Examples (Secondary Use)

### Download full video
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ
```

### Download in specific quality
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --quality 720p
```

### Extract full audio
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --audio-only
```

## Available Options

| Option | Description | Example |
|--------|-------------|---------|
| `--clip <start>-<end>` | **PRIMARY FEATURE** - Clip from start to end time | `--clip 00:30-02:15` |
| `--quality <resolution>` | Specify quality (720p, 1080p, best) | `--quality 1080p` |
| `--audio-only` | Extract audio as MP3 | `--audio-only` |
| `--output <filename>` | Custom output filename | `--output my_clip.mp4` |
| `--format <format>` | Output format (mp4, mkv, webm, mp3) | `--format mkv` |

## Time Format for Clipping

The skill accepts flexible timestamp formats:
- **MM:SS**: `01:30` (1 minute 30 seconds)
- **HH:MM:SS**: `01:15:30` (1 hour 15 minutes 30 seconds)
- **M:SS**: `1:30` (same as 01:30)
- **SS**: `90` (converted to 01:30)

## How Clipping Works

1. You provide a YouTube URL and time range
2. Claude parses your timestamps
3. The skill extracts just that section using optimized methods:
   - **Method 1**: yt-dlp's native clipping (fastest)
   - **Method 2**: ffmpeg precise cutting (fallback)
4. Your clip is saved to the current directory

## Use Cases

### Content Creators
- Extract highlights for shorts or reels
- Clip reaction sections
- Create compilation segments
- Extract B-roll footage

### Educators
- Clip specific tutorial steps
- Extract lecture segments
- Create study materials
- Share specific explanations

### Musicians
- Extract song sections
- Clip audio for remixes
- Get specific verses or choruses
- Create practice loops

### Researchers
- Extract relevant video segments
- Create timestamped references
- Archive specific content
- Analyze particular sections

## Output Location

All clips and downloads are saved to your current working directory. You can specify a custom path using the `--output` flag.

## Important Notes

- **Pure Python solution** - no binary dependencies, just Python
- **Auto-installs dependencies** - yt-dlp Python module installed automatically if needed
- **Clipping is optimized and fast** - no need to download full videos first
- **Quality is maintained** - clips preserve the original video quality
- **Copyright matters** - only clip content you have rights to access
- **Flexible timestamps** - use whatever format is natural for you
- **Minimal setup** - Python is usually pre-installed, everything else is automatic

## Technical Details

- **Language**: Pure Python implementation
- **Primary Library**: yt-dlp Python module (auto-installed via pip)
- **Audio Processing**: ffmpeg (required for audio extraction, usually pre-installed)
- **Supported Formats**: All standard video and audio formats
- **URL Support**: youtube.com, youtu.be, and all YouTube URL variants
- **Installation**: Fully automatic - checks and installs yt-dlp module as needed

## Troubleshooting

### Clip not extracting correctly
The skill will automatically try alternate methods if the first approach fails.

### Invalid timestamps
Use format: MM:SS or HH:MM:SS (e.g., `01:30` or `01:15:30`)

### Video unavailable
Verify the YouTube URL is correct and the video is publicly accessible.

## License

MIT License

## Support

For issues or questions, visit the project repository or submit feedback through ClawHub.
