# ClawHub - YouTube Video Clipper & Downloader

A powerful ClawHub skill for extracting specific sections from YouTube videos with precise timestamps. Clip highlights, extract audio segments, or download full videos - all through a simple conversational interface.

## Features

### Primary: Video Clipping
- **Precise timestamp-based clipping** (MM:SS or HH:MM:SS format)
- Clip in any quality (720p, 1080p, best available)
- Extract audio clips as MP3
- Fast and optimized processing

### Secondary: Full Downloads
- Download complete videos in various qualities
- Extract full audio tracks
- Custom output filenames and formats
- Progress tracking

## Installation

Install this skill in ClawHub by uploading it to https://www.clawhub.ai/upload

For local installation: `./install.sh`

## Usage

```
/clawhub <youtube-url> [options]
```

## Options

- `--clip <start>-<end>` - **PRIMARY FEATURE** - Clip from start to end time (MM:SS or HH:MM:SS)
- `--quality <resolution>` - Specify quality (e.g., 720p, 1080p, best)
- `--audio-only` - Extract audio as MP3
- `--output <filename>` - Custom output filename
- `--format <format>` - Output format (mp4, mkv, webm, mp3, etc.)

## Examples

### Clip specific sections (Primary use)
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --clip 00:30-02:15
```

### Clip with quality
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --clip 01:00-03:30 --quality 1080p
```

### Clip audio only
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --clip 00:10-01:00 --audio-only
```

### Clip with custom filename
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --clip 02:00-04:30 --output highlight.mp4
```

### Download full video (Secondary)
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ
```

### Download specific quality
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --quality 720p
```

### Extract full audio
```
/clawhub https://youtube.com/watch?v=dQw4w9WgXcQ --audio-only
```

## Use Cases

- **Content Creators**: Extract highlights for shorts or reels
- **Educators**: Clip specific tutorial steps or lecture segments
- **Musicians**: Extract song sections or create practice loops
- **Researchers**: Archive and analyze specific video segments

## How It Works

1. Provide a YouTube URL and optional time range
2. Claude parses your request and timestamps
3. The skill extracts the section using optimized methods
4. Your clip is saved to the current directory

## Important Notes

- **Pure Python solution** - no binary dependencies required
- **Auto-installs yt-dlp** - Python module installed automatically if not present
- Clipping is optimized - no need to download full videos first
- Quality is maintained during clipping
- Respect copyright - only clip content you have rights to access
- Clips are saved to the current working directory
- Minimal setup - Python (usually pre-installed) is the only requirement

## Technical Details

The skill uses:
- **Python implementation** using yt-dlp library (not CLI binary)
- **Auto-installation** via pip if yt-dlp module is missing
- `ffmpeg` for audio extraction (usually pre-installed)
- Supports all YouTube URL formats (youtube.com, youtu.be, etc.)
- **Cross-platform** - works on macOS, Linux, and Windows

## License

MIT License

## Contributing

Contributions are welcome! Feel free to submit issues or pull requests to improve this skill.
