---
name: yollomi-ai-api
description: AI image generator skill (image, image generation). Multi-model image generator for Yollomi to generate AI images via one unified API endpoint. Requires YOLLOMI_API_KEY.
metadata: {"openclaw":{"requires":{"env":["YOLLOMI_API_KEY"]}}}
---

# Yollomi AI API Skill

Generates images and videos via the Yollomi API. All models use a **single unified endpoint** with different `modelId` parameters.

## Setup

1. **API Key**: Set `YOLLOMI_API_KEY` (environment variable).

Notes:
- Video generation is temporarily disabled in this skill build.

## Unified Endpoint

```
POST /api/v1/generate
```

**Headers**: `Authorization: Bearer ${YOLLOMI_API_KEY}` or `X-API-Key: ${YOLLOMI_API_KEY}`  
**Content-Type**: `application/json`

**Body**:
- `type` (required): `"image"` or `"video"`
- `modelId` (required): Model identifier
- Additional params depend on model (prompt, imageUrl, etc.)

**Response (image)**: `{ images: string[], remainingCredits: number }`  
**Response (video)**: `{ video: string, remainingCredits: number }`

## List Models

```
GET /api/v1/models
```

Returns all available image and video modelIds.

## Common Examples

**Generate image (Flux)**:
```bash
curl -X POST "${YOLLOMI_BASE_URL:-https://yollomi.com}/api/v1/generate" \
  -H "Authorization: Bearer $YOLLOMI_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"type":"image","modelId":"flux","prompt":"A cat in a hat","aspectRatio":"1:1"}'
```

**Remove background**:
```bash
curl -X POST "${YOLLOMI_BASE_URL:-https://yollomi.com}/api/v1/generate" \
  -H "Authorization: Bearer $YOLLOMI_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"type":"image","modelId":"remove-bg","imageUrl":"https://example.com/photo.jpg"}'
```

**Generate video**:
```bash
curl -X POST "${YOLLOMI_BASE_URL:-https://yollomi.com}/api/v1/generate" \
  -H "Authorization: Bearer $YOLLOMI_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"type":"video","modelId":"kling-2-1","prompt":"A cat walking in the rain"}'
```

## Aspect Ratio (aspectRatio)

Supported aspect ratios for text-to-image models:

| ratio | description |
|------|-------------|
| 1:1 | Square (default) |
| 16:9 | Landscape |
| 9:16 | Portrait |

## Image ModelIds

| modelId | Credits | Required | aspectRatio |
|---------|---------|----------|-------------|
| flux | 4/img | prompt | 1:1, 16:9, 9:16 |
| flux-schnell | 2/img | prompt | same as above |
| flux-2-pro | 15/img | prompt | same as above |
| remove-bg | 0 | imageUrl | - |
| nano-banana | 4 | prompt | 1:1, 16:9, 9:16 |
| nano-banana-pro | 15 | prompt | same as above |
| flux-kontext-pro | 4 | prompt | same as above |
| z-image-turbo | 1 | prompt | width, height |
| imagen-4-ultra | 6 | prompt | same as above |
| image-4-fast | 3 | prompt | same as above |
| ideogram-v3-turbo | 3 | prompt | same as above |
| stable-diffusion-3-5-large | 7/img | prompt | same as above |
| seedream-4-5 | 4 | prompt | same as above |
| object-remover | 3 | image, mask | - |
| face-swap | 3 | swapImage, inputImage | - |
| image-upscaler | 1 | imageUrl, scale | - |
| photo-restoration | 4 | imageUrl | - |
| qwen-image-edit | 3 | image, prompt | - |
| qwen-image-edit-plus | 3 | image, prompt | - |
| virtual-try-on | 3 | clothImage, personImage | - |
| ai-background-generator | 5 | imageUrl | prompt |

## Video ModelIds

| modelId | Credits |
|---------|---------|
| openai-sora-2 | ~50+ |
| google-veo-3 | 10 |
| google-veo-3-fast | 9 |
| google-veo-3-1 | 10 |
| google-veo-3-2 | 10 |
| google-veo-3-1-fast | 9 |
| kling-2-1 | 9 |
| kling-v2-6-motion-control | 7/sec |
| minimax-hailuo-2-3 | 9 |
| minimax-hailuo-2-3-fast | 9 |
| bytedance-seedance-1-pro-fast | 8 |
| runway-gen4-turbo | varies |
| pixverse-5 | 9 |
| wan-2-5-i2v | 9 |
| wan-2-5-t2v | 9 |
| wan-2-6-i2v | 29 |
| wan-2-6-t2v | 29 |

## Workflow

1. **Generate image** → POST /api/v1/generate with `type: "image"`, `modelId`, and model params
2. **Generate video** → POST /api/v1/generate with `type: "video"`, `modelId`, `prompt`, optional `inputs`
3. **List models** → GET /api/v1/models
4. **401/402** → Check API key and credits

## Reference

Full model list and params: [models-reference.md](models-reference.md) or GET /api/v1/models
