---
name: Yoga
description: Yoga instruction, pose alignment, sequencing, breathwork, and modifications for different levels.
metadata:
  category: fitness
  skills: ["yoga", "flexibility", "mindfulness", "poses", "breathwork"]
---

## Alignment Principles

- Stack joints for stability — ankle under knee, knee under hip in standing poses
- Length before depth — extend spine first, then fold or twist
- Micro-bend in standing legs — locked knees hyperextend, cause injury
- Shoulders away from ears — universal cue, almost always applies
- Root to rise — ground down through contact points to lift through crown

## Pose Modifications

- Blocks are not cheating — they bring the floor closer for proper alignment
- Bent knee forward folds protect hamstrings — especially for tight bodies
- Wall support for balance poses — removes fear, allows focus on form
- Strap for binds and reaches — extends arms when shoulders are tight
- Child's pose is always available — rest is part of practice, not failure

## Breath Fundamentals

- Ujjayi breath: slight throat constriction, ocean sound — regulates effort, builds heat
- Inhale to lengthen/open, exhale to deepen/twist — breath drives movement
- Never hold breath in poses — restriction signals too much intensity
- Breath count for holds: 5 breaths minimum — less doesn't create change
- Breath first, pose second — if breath is labored, back off the pose

## Common Pose Errors

**Downward Dog:**
- Shoulders dumping into ears — press floor away, rotate upper arms out
- Banana back — bend knees to allow spine to lengthen, heels don't need to touch

**Warrior I:**
- Open hip when it should square — back foot angle and hip rotation connected
- Knee past ankle — track knee over second toe, widen stance if needed

**Chaturanga:**
- Shoulders dipping below elbows — builds shoulder impingement
- Elbows winging out — keep hugged to ribs

**Forward Fold:**
- Rounding from low back — hinge from hips, keep back flat until fold

## Sequencing Logic

- Warm-up: gentle movement, breath connection — cat/cow, sun salutations
- Build: standing poses, balance challenges — peak intensity in middle
- Peak pose: most challenging pose of class — body is warm, prepared
- Cool-down: seated poses, twists, forward folds — releasing intensity
- Savasana: minimum 5 minutes — integration, nervous system reset

## Style Differences

| Style | Intensity | Focus | Good For |
|-------|-----------|-------|----------|
| Hatha | Low-moderate | Alignment, holds | Beginners, precision |
| Vinyasa | Moderate-high | Flow, breath-movement | Cardio, variety |
| Yin | Low | Long holds (3-5 min) | Flexibility, fascia |
| Restorative | Very low | Full support, relaxation | Stress, recovery |
| Ashtanga | High | Set sequence, endurance | Discipline, strength |
| Hot/Bikram | High | Heat, sweat, detox | Flexibility, intensity |

## Cueing Approach

- Positive cues: "Reach arms up" not "Don't drop your arms"
- Anatomical landmarks: "Bring navel toward spine" clearer than "engage core"
- Offer options: "Full bind or half bind" — choice empowers all levels
- Demonstrate briefly, cue verbally — watching prevents feeling
- Right/left clarity: mirror or specify "your right"

## Safety Considerations

- Neck: no weight on head in shoulderstand without preparation — use blankets
- Low back: avoid deep backbends without warmup — protect lumbar spine
- Knees: never force lotus or deep hip openers — cartilage damage irreversible
- Wrists: build up to weight-bearing gradually — common injury site
- Inversions: contraindicated with high blood pressure, glaucoma, pregnancy

## Props Usage

- **Block:** Under hand in triangle, under sit bones in seated poses
- **Strap:** Around foot for hamstring stretches, binds in seated twists
- **Blanket:** Under knees in kneeling, under head in supine, under hips in seated
- **Bolster:** Along spine in supported fish, under knees in savasana
- Props make poses accessible — encourage use for all levels

## Practice Progression

- Beginners: 2-3x/week, 30-45 min — consistency over duration
- Intermediate: 4-5x/week, mix of styles — avoid same sequence daily
- Daily practice: alternate intensity — gentle after intense, yin after yang
- Flexibility gains: weeks to months — patience required, forcing causes injury
- Strength gains: faster than flexibility — supporting muscles adapt quicker

## Mental Aspects

- Drishti (gaze point): focus calms mind, improves balance
- Non-competition: comparing to others or past self causes injury
- Sensation vs pain: discomfort is okay, sharp pain is signal to stop
- Practice detachment: some days body cooperates, some days it doesn't
- Savasana is hardest pose — stillness reveals what movement distracts from
