# Category Examples

This reference provides examples of typical YNAB budget categories. Adapt these to your own budget structure.

## Common Category Groups

### Essential / Fixed Costs

Regular bills that must be paid:
- Rent/Mortgage
- Utilities (Electric, Gas, Water)
- Internet/Phone
- Insurance
- Groceries
- Healthcare
- Transportation

### Quality of Life

Investments in wellbeing:
- Fitness/Gym
- Education
- Books/Learning
- Hobbies

### Discretionary / Fun

Entertainment and treats:
- Dining Out
- Subscriptions (Streaming, etc.)
- Shopping
- Entertainment
- Social (Treating friends/family)

### Work/Business

If self-employed or tracking business expenses:
- Software/Services
- Professional Development
- Business Travel
- Equipment

### Variable but Necessary

Expenses that vary but are still needs:
- Car Maintenance
- Home Repairs
- Personal Care
- Gifts

### Savings/Investments

Future-focused:
- Emergency Fund
- Retirement
- Investments
- Large Purchase Savings

## Category Best Practices

### Be Specific Where It Matters

- **Too broad**: "Food" (mixes groceries with dining out)
- **Better**: "Groceries" + "Dining Out" (tracks spending habits clearly)

### Group Logically

Group related categories together:
- "Auto" group: Fuel, Maintenance, Insurance, Registration
- "Home" group: Mortgage/Rent, Utilities, Repairs, Furnishings

### Handle Edge Cases Consistently

**Parking**: Transportation or Auto? Pick one and stick to it.
**Fuel**: Auto or Transportation? Be consistent.
**Pet expenses**: Dedicated "Pet" category or split across categories?

Document your choices for consistency.

## Merchant-Category Mapping

Create a mapping of common merchants to categories for consistency:

| Type | Typical Category |
|------|------------------|
| Hair salon / Barber | Personal Care |
| Grocery stores | Groceries |
| Gas stations | Auto: Fuel |
| Parking | Transportation |
| Restaurants | Dining Out |
| Streaming services | Subscriptions |
| Gym | Fitness |
| Pharmacy | Healthcare |

Keep this mapping in a local note or config for reference when categorizing.

## Split Transaction Guidelines

Use split transactions when a single purchase spans multiple categories:

**Example**: Grocery store trip
- €50 food → Groceries
- €15 household items → Household Goods
- €10 pharmacy → Healthcare

**Why split**: Accurate category tracking for budgeting decisions.

## Categories to Exclude from Budget Totals

When calculating "true spending" vs income/expenses:

**Common exclusions**:
- **Tax payments**: Mandatory obligations (not discretionary spending)
- **Transfers**: Moving money between accounts (not spending)
- **Reimbursements/Advances**: Temporary (will be paid back)
- **Investments**: Capital allocation (not consumption)

**Depends on goals**:
- Major one-time purchases (car, home repairs) - may want separate "extraordinary" tracking
- Savings goals - are these "spending" or "allocation"?

Define your own exclusion rules based on what you're trying to measure.

## Multi-Currency Notes

If tracking expenses in multiple currencies:
- YNAB converts at entry time
- Consider separate budgets per currency for clarity
- Or use budget categories to track currency (e.g., "Travel: EUR", "Travel: USD")

## Tips

1. **Review monthly**: Are categories still useful? Merge unused ones.
2. **Consistency over perfection**: It's more important to be consistent than to have the "perfect" category structure.
3. **Rename as needed**: If a category name is confusing, rename it. YNAB history is preserved.
4. **Use memo field**: Add notes for unusual categorizations so you remember next time.
