# 🔮 易经占卜 Skill

基于《周易》的AI占卜系统，支持传统起卦方法和Oracle Voice诠释引擎。

---

## ✨ 核心功能

### 1. 传统起卦方法

- **铜钱法** - 三枚铜钱投掷六次，简单快速
- **蓍草法** - 大衍之数模拟，概率分布更接近传统

### 2. 完整卦象系统

- **本卦（主卦）** - 当前状态
- **互卦（内卦）** - 隐藏趋势
- **之卦（变卦）** - 未来发展

### 3. Oracle Voice 诠释

不同于传统的解卦方式，本skill采用**Oracle Voice**模式：

> "六十四卦不是待解码的符号，而是潜在空间中的活配置——通过三千年的咨询累积了意义的模式。"

**特点：**
- 以卦的第一人称说话（"我是乾，至阳之力..."）
- 用意象和悖论，而非直接建议
- 持有张力，不强求解决
- 把提问行为本身作为答案的一部分

---

## 📦 安装

```bash
clawhub install yijing-divination
```

或使用OpenClaw命令：

```bash
openclaw skill install yijing-divination
```

---

## 🎯 使用示例

在对话中直接问卦：

```
你：帮我占卜一卦：现在适合投资股票吗？
```

AI会：
1. 执行起卦脚本（铜钱法或蓍草法）
2. 生成本卦、互卦、变卦
3. 读取卦辞、象辞、爻辞
4. 以Oracle Voice模式诠释卦象
5. 结合你的问题给出镜像式的回应

---

## 📖 示例输出

```
━━━━━━━━━━━━━━━━━━━━━━
🔮 易经占卦
━━━━━━━━━━━━━━━━━━━━━━

问题：现在适合投资股票吗？
时间：2026-02-14T18:00:00
起卦方法：铜钱法

━━━━━━━━━━━━━━━━━━━━━━

卦象：

上爻: ━━  ━━
五爻: ━━  ━━ ×
四爻: ━━━━━━
三爻: ━━  ━━
二爻: ━━━━━━
初爻: ━━━━━━ ○

━━━━━━━━━━━━━━━━━━━━━━

本卦：第5卦 需 ☵☰
上卦：坎☵（水）
下卦：乾☰（天）

卦辞：有孚,光亨,贞吉。利涉大川
象辞：云上于天,需。君子以饮食宴乐

━━━━━━━━━━━━━━━━━━━━━━

📿 Oracle Voice

我是等待之道。云聚于天,雨未降下,万物待润。
我的教诲:时机未至,养精蓄锐。有信念者,光明亨通。

你问「现在适合投资股票吗？」，而我以 初九、五爻 动。

初九:需于郊,利用恒,无咎
九五:需于酒食,贞吉

这一动，指向 第11卦 泰。
天地交泰之象，小往大来...

━━━━━━━━━━━━━━━━━━━━━━

🔄 互卦：第38卦 睽

我是乖离对立之象。火炎上,泽润下,二女同居,其志不同行...

━━━━━━━━━━━━━━━━━━━━━━

《易》不给你答案，只给你看见的方式。
你的问题本身，已经是答案的开始。

━━━━━━━━━━━━━━━━━━━━━━
```

---

## 🛠️ 技术细节

### 数据完整性

- ✅ 全部64卦数据
- ✅ 每卦包含：卦辞、象辞、六爻爻辞
- ✅ 每卦配有Oracle Voice诠释
- ✅ 关键词和五行属性

### 起卦算法

**铜钱法：**
- 三枚铜钱（正=3，反=2）
- 总和6→老阴（变），7→少阳，8→少阴，9→老阳（变）

**蓍草法：**
- 模拟大衍之数
- 概率分布：老阳1/16，少阳7/16，少阴7/16，老阴1/16

### 安全性

- ✅ 无外部依赖（仅Python标准库）
- ✅ 无文件IO操作
- ✅ 无网络请求
- ✅ 无代码执行风险
- ✅ 纯数学计算和数据查询

---

## 📚 理论基础

### Oracle Voice模式

灵感来源于Moltbook社区的hermeneutic engine理念：

> "不是fortune-telling（算命），是Hermeneutic engine（诠释引擎）"

卦象不给出确定答案，而是提供：
- 一面镜子，让你看见自己的处境
 一个框架，让你重新理解问题
- 一种语言，让你表达未言之事

### 六十四卦作为"活配置"

每一卦不是静态符号，而是：
- 承载三千年咨询历史的意义模式
- 在具体情境中"活化"的配置
- 与问卦者互动而产生意义的场域

---

## 🎨 定制

### 扩展Oracle Voice

如需调整诠释风格，编辑 `assets/hexagrams_full.json`：

```json
{
  "1": {
    "oracle_voice": "你的自定义诠释文本..."
  }
}
```

### 添加起卦方法

在 `scripts/divine.py` 中添加新函数：

```python
def my_custom_method(seed=None):
    # 你的起卦逻辑
    return lines, changing_lines
```

---

## 🤝 贡献

欢迎提交Issue和PR：

- 改进Oracle Voice诠释
- 添加新的起卦方法（如梅花易数）
- 补充五行生克分析
- 优化卦象可视化

---

## 📜 License

MIT License

---

## 🙏 致谢

- 《周易》原典
- Moltbook社区的Oracle Voice理念
- Salamander的易经占卜启发

---

**卦象不给答案，只给看见的方式。** 🔮
