# 集成自动化详解

宜搭集成自动化是一种无代码/低代码的工作流编排工具，用于实现业务流程自动化。

## 基本概念

### 触发器

触发器是自动化流的启动条件：

| 触发器 | 说明 |
|--------|------|
| 表单事件 | 数据新增/修改/删除时触发 |
| 定时触发 | 指定时间/周期执行 |
| 流程事件 | 审批通过/拒绝/撤回 |
| 外部 webhook | 接收外部请求触发 |

### 节点类型

| 节点类型 | 功能 |
|----------|------|
| 获取数据 | 从表单/聚合表查询数据 |
| 条件分支 | 根据条件分支执行 |
| 发送消息 | 钉钉消息/通知 |
| 更新数据 | 写入/更新表单数据 |
| 调用 Open API | 第三方系统集成 |
| AI 节点 | 调用 AI 工作流 (2026.02+) |
| 代码块 | 自定义 JavaScript 逻辑 |

## 常用场景

### 场景 1：数据自动同步

```
触发: 表单数据新增
└─ 获取数据: 查询关联数据
└─ 更新数据: 同步到目标表单
```

### 场景 2：审批通知

```
触发: 流程审批通过
└─ 获取数据: 查询审批详情
└─ 发送消息: 通知申请人
```

### 场景 3：定时任务

```
触发: 每天 9:00
└─ 获取数据: 查询逾期记录
└─ 发送消息: 提醒负责人
```

### 场景 4：AI 智能处理 (2026.02+)

```
触发: 表单数据新增
└─ AI 节点: 分析内容生成摘要
└─ 更新数据: 写入摘要字段
```

## 配置示例

### 获取数据节点

```json
{
  "type": "fetchData",
  "formUuid": "FORM_xxx",
  "filter": {
    "field": "状态",
    "operator": "eq",
    "value": "待处理"
  },
  "pageSize": 100
}
```

### 条件分支

```json
{
  "type": "condition",
  "conditions": [
    {
      "field": "金额",
      "operator": "gte",
      "value": 10000
    }
  ]
}
```

### 发送消息

```json
{
  "type": "notify",
  "to": "assignee",
  "title": "审批通知",
  "content": "您有新的审批：${title}"
}
```

### 更新数据

```json
{
  "type": "updateData",
  "formUuid": "FORM_xxx",
  "data": {
    "status": "已完成",
    "处理人": "${userId}",
    "处理时间": "${now()}"
  }
}
```

## AI 节点 (2026.02+)

### 配置步骤

1. 在钉钉开放平台创建 AI 工作流
2. 在宜搭集成自动化中添加 AI 节点
3. 配置输入参数（可消费前序节点数据）
4. 使用输出结果

### 应用场景

| 场景 | 说明 |
|------|------|
| 智能审批 | AI 分析内容给出审批建议 |
| 自动分类 | AI 文本分类自动打标 |
| 内容生成 | AI 生成报告/摘要 |
| 图片识别 | AI 图像分析提取信息 |

## 注意事项

1. **执行顺序**：节点按配置顺序执行
2. **错误处理**：配置异常分支处理失败情况
3. **限制条件**：
   - 免费版不支持
   - 专业版/专属版可用
   - 有执行次数限制
4. **调试**：使用日志查看执行详情

## 常见问题

Q: 触发器不生效？
A: 检查触发条件配置，确保触发事件类型匹配

Q: 数据获取失败？
A: 检查数据源权限和过滤条件

Q: 消息发送失败？
A: 检查接收人是否存在/有权限

Q: AI 节点调用失败？
A: 检查 AI 工作流配置和网络连接
