# YC Cold Email Outreach - Reference Guide

## 1. The Goal
- The goal of a cold email is **not to make the sale**.
- The goal is to **get to the next step in the funnel** (e.g., a demo, a meeting, or a referral).

## 2. Targeting (The Highest Leverage)
- Better to send **100 targeted emails** than 1,000 untargeted ones.
- Find people who actually want what you've made.
- Targeting improves both open rates and response rates.

## 3. The Seven Principles of Effective Email Copy

### I. Focused, Specific Goal
- One email = One desired outcome.
- Multiple asks create a "paradox of choice" and lead to deletion.
- Every word must drive toward that single goal.

### II. Be Human
- Write like you’re talking to a friend.
- Use emotions: "I'd love to," "I'd really appreciate," "Thanks."
- Be informal: Use "Hey [Name]" instead of "Hello Mr. [Name]."
- Minor typos or lack of perfect capitalization can actually signal "human" over "bot."

### III. Personalize
- "Hi there" is generic; "Hey Aaron" is personal.
- Go beyond swapping a company name. Mention something specific: "I’ve been a fan since you launched the X category."
- Find **Uncommon Commonalities**: Unique shared experiences (same niche building, same obscure college building).
- Personalization proves you did the work and you care about the connection.

### IV. Keep it Short
- Walls of text are instant deletes.
- Ensure it's easy to read and respond to on a mobile phone.
- Low cognitive overhead = higher response rate.

### V. Establish Credibility
- Mention former schools, companies, or impressive past achievements.
- Use **Social Proof**: Mention well-known customers or competitors using your product.
- Share useful industry-specific data or trends to establish expertise.

### VI. It's About the Reader (Not You)
- Reframe "I" and "Me" into "You" and "Yours."
- Tell your story as a quest to **solve their problems**.
- Use the **actual language** your users use to describe their pain points.
- Don't make demands; you are in their inbox on their time.

### VII. Clear Call to Action (CTA)
- Standalone sentence/paragraph at the end.
- Concrete next step: "Reply to let me know," "Click here to start," "Can you intro me to X?"
- Make it so simple they can take the action in seconds.

## 4. The Strategy
- **Do it Manually First**: Don't start with automation. Learn what works, then scale.
- **Founders Should Send**: Emails from a Founder/CEO have much higher credibility than from an intern or salesperson.
- **Persistence**: One email is rarely enough. Plan to follow up 2, 3, or 4 times (wait a few days between).
- **Be Creative**: If they don't respond, try something different (e.g., a different subject line or a personalized video/GIF).
- **No Resentment**: Nobody owes you a response. If they don't reply, move on and check back in a few months.
