# 用户案例风格指南

本文件总结了用户提供的真实研学课程方案的风格特点，用于指导生成符合用户偏好的方案。

## 一、语言风格特点

### 1. 开篇诗意化
所有案例都以优美的散文式语言开篇，营造季节氛围和活动期待：

**示例：**
> 春日暖阳，消融冬日寒意；
> 枝头新绿，尽染蓬勃生机。
> 春日和风，裹挟草木清香；
> 耳畔轻吟，唤醒万物生长。
> 这融融春光、缕缕清风，
> 正是大自然向同学们发出的美好邀约。

**要点：**
- 使用四字词语、对仗句式
- 描写季节特征（春、秋等）
- 营造期待感和仪式感
- 引出活动主题

### 2. 正式且富有感染力
- 使用书面语，避免口语化表达
- 善用排比、比喻等修辞手法
- 段落之间逻辑清晰，层层递进
- 情感饱满，能激发学生参与热情

### 3. 专业术语规范
- 政策引用准确（教育部文件名称）
- 学科知识表述严谨
- 景区介绍使用官方描述

## 二、结构特点

### 1. 课程背景（三维度）
每个案例都包含三个维度：
- **政策导向**：引用教育部相关文件，说明政策依据
- **教育现状**：分析当前教学痛点，说明实践必要性
- **资源优势**：详细介绍景区特色，关联教育价值

### 2. 课程主题命名
采用"主标题+副标题"形式：
- 主标题：简洁有力，四字对仗
- 副标题：解释说明，突出教育意义

**示例：**
- 主标题："乐游奇境拓视野 研学新知润成长"
- 副标题："玩转苏州乐园 探索科学与欢乐"

### 3. 课程意义/意义论述
单独设置"课程意义"板块，从多个维度阐述：
- 衔接理论与实践
- 提升综合能力
- 厚植多元素养
- 释放身心压力

### 4. 课程目标详实
分为知识、能力、素养三类，每类5-6条：
- 使用**加粗**突出关键内容
- 表述具体可操作
- 体现不同学科融合

### 5. 课程实施分时段
按上午/下午分时段描述：
- 每个景点独立成章
- 包含景点介绍+推荐项目+思考探究
- 思考探究2-3道开放性题目

## 三、课程亮点设计

### DIY活动描述特点
1. **诗意引入**：用古诗词或优美句子引出活动
2. **问题导向**：以问题激发好奇心
3. **步骤详细**：分步骤说明制作过程
4. **教育意义**：强调知识与趣味的结合

**示例结构：**
```
【活动名称】
"风有方向吗？风又从哪个方向吹来？"（引言）

古诗词引入...（文化渲染）

问题提出...（激发兴趣）

活动过程描述...（详细步骤）

教育意义总结...
```

## 四、思考探究题设计

### 题目特点
1. **结合场景**：与具体游乐设施或景点紧密结合
2. **跨学科**：融合物理、生物、地理等多学科知识
3. **开放性**：没有标准答案，鼓励思考
4. **可操作性**：学生能够实际观察和体验

### 示例题型
- 观察类："观察XX和普通XX的区别..."
- 体验类："当你做XX时，身体会有什么感觉？"
- 探究类："猜猜机器是怎么知道该让XX动起来的？"
- 联系类："这和课本上学的XX有什么相似之处？"

## 五、安全注意事项

### 分类细致
分为三大类，每类多条：
1. **乘车安全**：安全带、秩序、应急
2. **活动安全**：设施使用、行为规范
3. **饮食/其他安全**：用餐、财物、健康

### 表述特点
- 使用"严禁""必须""务必"等强调词
- 具体到每个环节的风险点
- 给出明确的处置建议

## 六、研学任务单

### 结构完整
1. **基本信息**：姓名、班级、日期、同行人
2. **我的收获**：3-5道开放式问题
3. **我的作品**：DIY作品记录或拍照区
4. **家长评价**：家长签名和留言

### 题目类型
- 知识回顾题（填空/选择）
- 观察记录题（画图/描述）
- 感悟反思题（开放作答）
- 家长互动题（家庭延伸）

## 七、格式规范

### 标题层级
- 主标题：无标记，居中或加粗
- 一级标题：一、二、三...（课程背景、实施对象等）
- 二级标题：（一）（二）（三）...（政策导向、教育现状等）
- 三级标题：1. 2. 3. ...（具体条目）

### 强调方式
- **加粗**：重要概念、关键内容
- 引用：古诗词、政策原文
- 表格：课程安排、评价表

### 排版特点
- 段落之间空一行
- 重点内容单独成段
- 使用项目符号列举

## 八、内容深度要求

### 按年级区分

**小学低年级（1-2年级）**
- 语言简单，多用图画引导
- 活动以体验为主，知识渗透为辅
- 安全提示详细具体，语气温柔

**小学高年级（3-6年级）**
- 增加观察记录要求
- 引导简单科学探究
- 强调团队协作

**初中（7-9年级）**
- 知识深度增加，跨学科融合
- 强调科学原理解释
- 鼓励独立思考和创新

**高中**
- 主题深化，联系学科知识
- 培养研究能力和批判思维
- 强调价值观引导

## 九、常用表达模板

### 开篇模板
```
[季节]暖阳，[季节特征]。
[自然景象]，[生机描述]。
这[美好事物]，
正是大自然向同学们发出的美好邀约。
```

### 课程意义论述
```
（一）衔接理论与实践，深化知识理解
课堂教学中，[学科知识]多以[形式]呈现，学生[现状问题]。
本次实践活动将[知识]融入[场景]，让学生[具体体验]。
这种[方式]能帮助学生[达到效果]。

（二）提升综合能力，促进全面发展
活动以[形式]开展，全程需要学生[能力要求]。
学生的[能力1]、[能力2]得到有效锻炼。
```

### DIY活动引入
```
"[问题1]？[问题2]？"
奇妙的大自然，神奇的小实验，
开启同学们探索[主题]的故事。
让我们跟随[季节/事物]，
和同学们一起去"[活动名称]"吧！

"[古诗词1]""[古诗词2]"……
我们总能从古诗词中感受到[主题]的不同[特征]。
```

## 十、景区与活动搭配

### 常用组合（参考用户案例）

| 景区 | 适用年级 | DIY活动 | 主题方向 |
|------|----------|---------|----------|
| 苏州乐园 | 初中 | 风向标 | 科学探索 |
| 太湖西山岛开心农场 | 小学1-2年级 | 种植多肉/环保袋 | 自然体验 |
| 沙家浜 | 小学3-4年级 | 脸谱绘画 | 红色文化 |
| 同里古镇 | 小学5-6年级 | 团扇绘制 | 传统文化 |
| 红豆山庄 | 初中 | 香囊制作 | 传统文化 |
| 尚湖 | 初中 | 风向标 | 自然生态 |
| 白马涧 | 小学1年级 | 昆虫拼图 | 自然探索 |
| 渔洋山 | 初三/高中 | 励志拓展 | 团队建设 |
| 虎丘 | 全学段 | 拓碑/文化探究 | 历史文化 |

---

**使用建议：**
生成方案时，优先参考同年级、同类型景区的案例，学习其语言风格和结构安排。保持用户喜欢的诗意化开篇、详实的内容论述和丰富的思考探究题。
