# Яндекс.Календарь

Управление Яндекс.Календарём через CalDAV (vdirsyncer + khal)

## Доступные команды

### Показать события
- `vdirsyncer sync && khal list today` - события на сегодня
- `khal list today 7d` - события на неделю
- `khal calendar` - календарь на месяц

### Добавить событие
```bash
khal new "ДАТА ВРЕМЯ" "ДЛИТЕЛЬНОСТЬ" "НАЗВАНИЕ" && vdirsyncer sync
```

Примеры:
- `khal new "2026-02-10 15:00" "1h" "Встреча с клиентом"`
- `khal new "завтра 14:00" "30m" "Звонок"`

### Поиск
```bash
khal search "текст для поиска"
```

## Инструкции для бота

Когда пользователь спрашивает про календарь, используй эти команды:

**"Покажи события на сегодня"** или **"Что у меня сегодня?"**
→ Выполни: `vdirsyncer sync && khal list today`
→ Покажи результат пользователю

**"Что у меня на этой неделе?"** или **"События на неделю"**
→ Выполни: `khal list today 7d`

**"Добавь встречу [дата] в [время]"**
→ Выполни: `khal new "ДАТА ВРЕМЯ" "ДЛИТЕЛЬНОСТЬ" "НАЗВАНИЕ" && vdirsyncer sync`
→ Примеры дат: "завтра 15:00", "2026-02-10 14:00"

**"Найди событие про [тема]"**
→ Выполни: `khal search "тема"`

## Примечания

- Всегда синхронизируй перед показом событий: `vdirsyncer sync`
- После добавления события тоже синхронизируй: `&& vdirsyncer sync`
- Если vdirsyncer выдаёт ошибку, используй только `khal` без синхронизации
- Длительность: 30m (30 минут), 1h (1 час), 2h (2 часа)
