---
name: YAML
description: Write valid YAML that parses predictably across languages and versions.
metadata: {"clawdbot":{"emoji":"📋","os":["linux","darwin","win32"]}}
---

## Type Coercion Traps

- `yes`, `no`, `on`, `off`, `true`, `false` → boolean; quote if literal string: `"yes"`
- `NO` (Norway country code) → false in YAML 1.1; always quote country codes
- `1.0` → float, `1` → int; quote version numbers: `"1.0"`
- `010` → octal (8) in YAML 1.1; quote or use `0o10` explicitly
- `null`, `~`, empty value → null; quote if literal: `"null"`, `"~"`
- `.inf`, `-.inf`, `.nan` → special floats; quote if literal strings

## Indentation

- Spaces only—tabs are forbidden and cause parse errors
- Consistent indent width required within document—2 spaces conventional
- Sequence items `-` count as indentation—nested content aligns after the space

## Strings

- Colon followed by space `: ` triggers key-value—quote strings containing `: `
- `#` starts comment unless quoted—quote strings with `#`
- Leading/trailing spaces stripped from unquoted strings—quote to preserve
- Quote strings starting with `@`, `` ` ``, `*`, `&`, `!`, `|`, `>`, `{`, `[`, `%`

## Multiline Strings

- `|` literal block preserves newlines; `>` folded block joins lines with spaces
- Trailing newline: `|-` and `>-` strip final newline; `|+` and `>+` keep trailing blank lines
- Indentation of first content line sets the block indent—be consistent

## Structure

- Duplicate keys: YAML spec says last wins, but some parsers error—avoid duplicates
- Anchors `&name` and aliases `*name` reduce repetition—but aliases can't override anchor values
- Document separator `---` starts new document; `...` ends document—useful in streams
- Empty documents between `---` markers are valid but often unintended

## Comments

- `#` only valid at line start or after whitespace—`key:value#comment` has no comment
- No inline comments after multiline block scalars—comment applies to next line
- No multi-line comment syntax—each line needs `#`

## Compatibility

- YAML 1.1 vs 1.2: boolean words (`yes`/`no`), octal syntax differ—know which version parser uses
- JSON is valid YAML 1.2—but YAML features (anchors, multiline) don't round-trip to JSON
- Some parsers limit nesting depth or file size—test with expected data scale
