# Sentiment Analysis Guide

This guide explains how the sentiment analysis works in the Yahoo Finance FOREX skill.

## Overview

The sentiment analysis uses **keyword-based scoring** to determine market sentiment from news headlines. While not as sophisticated as deep learning NLP models, it provides a quick and reliable indicator of market bias.

## How It Works

### 1. Keyword Detection

The script scans news article titles for bullish and bearish keywords:

**Bullish Keywords (+1 point each):**
- strengthens, rallies, rally, gains, rises, climbs
- hawkish, rate hike, growth, strong, surge, up
- bullish, optimistic, positive, recovery, rebounds

**Bearish Keywords (-1 point each):**
- weakens, falls, declines, drops, slides, plunges
- dovish, rate cut, recession, weak, down, slumps
- bearish, pessimistic, negative, slowdown, tumbles

### 2. Score Calculation

```
Sentiment Score = (Bullish Keywords Count) - (Bearish Keywords Count)
```

**Example:**
```
News: "Euro rallies on hawkish ECB comments"
- "rallies" = +1
- "hawkish" = +1
Total: +2 (Bullish)

News: "Dollar weakens as Fed signals dovish stance"
- "weakens" = -1
- "dovish" = -1
Total: -2 (Bearish)
```

### 3. Recommendation Logic

Based on the aggregate sentiment score:

| Score Range | Sentiment | Recommendation |
|-------------|-----------|----------------|
| > +2 | Bullish | BUY |
| -2 to +2 | Neutral | HOLD |
| < -2 | Bearish | SELL |

## Interpretation Guidelines

### Strong Bullish (Score > +5)
- Multiple positive headlines
- Clear market consensus
- Strong momentum indicators
- **Action:** Consider long positions
- **Caution:** Watch for overextension

### Moderate Bullish (Score +3 to +5)
- Generally positive news flow
- Bullish bias present
- Room for continuation
- **Action:** Look for entry opportunities
- **Caution:** Confirm with technical analysis

### Neutral (Score -2 to +2)
- Mixed news sentiment
- No clear directional bias
- Consolidation likely
- **Action:** Wait for clearer signal
- **Caution:** Range-bound trading

### Moderate Bearish (Score -3 to -5)
- Generally negative news flow
- Bearish bias present
- Downside pressure exists
- **Action:** Consider short positions
- **Caution:** Look for support levels

### Strong Bearish (Score < -5)
- Multiple negative headlines
- Clear market consensus
- Strong downward momentum
- **Action:** Avoid longs, consider shorts
- **Caution:** Watch for capitulation

## Real-World Examples

### Example 1: EUR/USD Bullish Sentiment

**News Headlines:**
1. "Euro strengthens on strong PMI data" (+2)
2. "ECB maintains hawkish stance" (+1)
3. "EUR/USD rallies to 6-month high" (+1)
4. "Dollar weakens on dovish Fed comments" (+2)

**Total Score:** +6 (Strong Bullish)
**Recommendation:** BUY
**Analysis:** Multiple bullish factors supporting EUR strength

### Example 2: GBP/USD Bearish Sentiment

**News Headlines:**
1. "Pound falls on weak UK GDP" (-2)
2. "BoE signals dovish policy shift" (-1)
3. "Sterling slides to multi-week low" (-2)
4. "Brexit concerns weigh on pound" (-1)

**Total Score:** -6 (Strong Bearish)
**Recommendation:** SELL
**Analysis:** Multiple bearish factors pressuring GBP

### Example 3: USD/JPY Neutral Sentiment

**News Headlines:**
1. "Dollar holds steady vs yen" (0)
2. "Mixed US data leaves USD/JPY unchanged" (0)
3. "Traders await Fed decision" (0)

**Total Score:** 0 (Neutral)
**Recommendation:** HOLD
**Analysis:** Market waiting for catalyst

## Limitations

### What It Cannot Do

1. **Deep Context Analysis**
   - Cannot understand sarcasm or complex statements
   - Misses subtle nuances in articles
   - Cannot read article content (only headlines)

2. **Weight Different Sources**
   - All keywords weighted equally
   - Doesn't distinguish between Reuters and smaller outlets
   - Cannot assess source credibility

3. **Temporal Context**
   - Doesn't consider how recent news is
   - Cannot distinguish between speculation and confirmation
   - Misses the importance of timing

4. **Market Context**
   - Cannot assess if news is already priced in
   - Doesn't know current technical levels
   - Cannot judge if sentiment is contrarian signal

### Best Practices to Compensate

1. **Read the Headlines**
   - Don't rely solely on the score
   - Understand what's driving sentiment
   - Look for common themes

2. **Check Article Recency**
   - Recent articles (< 1 hour) more impactful
   - Old news may already be priced in
   - Look at timestamp field

3. **Cross-Reference Multiple Pairs**
   - If all USD pairs show same sentiment, USD is the driver
   - Divergences can reveal opportunities
   - Check correlated pairs

4. **Combine with Technical Analysis**
   - Use sentiment as confirmation
   - Check key support/resistance levels
   - Look at price action

5. **Consider Economic Calendar**
   - Major events override sentiment
   - Be cautious before big announcements
   - Post-event sentiment more reliable

## Advanced Usage

### Sentiment Divergence Trading

When sentiment contradicts price action:
- **Bullish news + falling price** = Potential reversal or news priced in
- **Bearish news + rising price** = Strong underlying strength or positioning

### Sentiment Confirmation

Best entry signals when:
- Sentiment aligns with technical breakout
- Sentiment + price action + economic data all agree
- Sentiment shift coincides with central bank policy

### Contrarian Signals

Extreme sentiment can be contrarian:
- Very high bullish sentiment (> +8) may indicate overcrowding
- Very high bearish sentiment (< -8) may indicate capitulation
- Watch for reversal patterns at extremes

## Customization

You can modify the keyword lists in `scripts/fetch_forex_news.py`:

```python
# Add your own keywords
BULLISH_KEYWORDS = [
    "strengthens", "rallies", ...,
    "your_custom_keyword"  # Add here
]

# Adjust scoring weights
# Currently all keywords = ±1 point
# You could implement weighted scoring for important keywords
```

## Validation Tips

### How to Validate Sentiment

1. **Read the headlines manually** - Do they match the score?
2. **Check market price action** - Is price moving with sentiment?
3. **Compare with other sources** - Does Bloomberg/Reuters agree?
4. **Track accuracy over time** - Keep a journal of predictions

### When to Trust Sentiment

- Multiple news sources reporting similar themes
- Clear central bank policy signals
- Significant economic data releases
- Geopolitical events with clear impact

### When to Be Skeptical

- Only 1-2 articles available
- Conflicting headlines
- Quiet news day (low volume)
- Pre-major event (waiting mode)

## Performance Metrics

To measure sentiment accuracy, track:
- **Directional Accuracy:** Did price move in recommended direction?
- **Magnitude:** How much did price move?
- **Timeframe:** How long did it take?
- **False Signals:** How often was sentiment wrong?

**Expected Performance:**
- Directional accuracy: ~60-70% for strong signals (>±5)
- Best in trending markets
- Worse in ranging/choppy markets
- Higher accuracy for major pairs (more news coverage)

## Integration with Trading Strategy

### Example Workflow

1. **Run sentiment analysis** for your target pair
2. **Evaluate the score:**
   - Score > +3: Look for long opportunities
   - Score < -3: Look for short opportunities
   - Score -2 to +2: Wait or trade range
3. **Read key headlines** to understand drivers
4. **Check technical levels** for entry/exit points
5. **Set risk management** based on volatility
6. **Monitor for sentiment shifts** that could invalidate trade

### Risk Management Based on Sentiment

| Sentiment Strength | Position Size | Stop Loss |
|-------------------|---------------|-----------|
| Strong (>±5) | Normal | Standard |
| Moderate (±3 to ±5) | Reduced 20% | Tighter |
| Weak (<±3) | Reduced 50% | Very tight |

## Conclusion

Sentiment analysis is a useful tool but should not be used in isolation. Combine it with:
- Technical analysis
- Fundamental analysis
- Risk management
- Market structure understanding
- Economic calendar awareness

The best results come from using sentiment as **one input among many** in your trading decision process.
