# FOREX Pairs Reference

Complete reference for the 7 major currency pairs supported by this skill.

## Pair Overview

| Pair | Name | Yahoo Symbol | Base | Quote | Nickname |
|------|------|--------------|------|-------|----------|
| EUR/USD | Euro Dollar | EURUSD=X | Euro | US Dollar | Fiber |
| GBP/USD | Pound Dollar | GBPUSD=X | British Pound | US Dollar | Cable |
| USD/JPY | Dollar Yen | USDJPY=X | US Dollar | Japanese Yen | Gopher |
| USD/CHF | Dollar Franc | USDCHF=X | US Dollar | Swiss Franc | Swissy |
| AUD/USD | Aussie Dollar | AUDUSD=X | Australian Dollar | US Dollar | Aussie |
| USD/CAD | Dollar Loonie | USDCAD=X | US Dollar | Canadian Dollar | Loonie |
| NZD/USD | Kiwi Dollar | NZDUSD=X | New Zealand Dollar | US Dollar | Kiwi |

## Detailed Pair Information

### EUR/USD (Euro Dollar) 🇪🇺🇺🇸

**Most Traded Pair in the World**
- **Trading Volume:** ~28% of global FOREX volume
- **Key Drivers:** ECB policy, Fed policy, Eurozone economic data, US economic data
- **Central Banks:** European Central Bank (ECB) vs Federal Reserve (Fed)
- **Trading Hours:** Most liquid during European and US sessions
- **Typical Spread:** 0.1-0.5 pips
- **Volatility:** Moderate

**Key Economic Indicators:**
- Eurozone GDP, inflation, PMI data
- US NFP, CPI, GDP, retail sales
- ECB and Fed interest rate decisions
- ECB and Fed press conferences

**Trading Characteristics:**
- Most liquid pair globally
- Tight spreads
- Responds strongly to monetary policy
- Affected by geopolitical events in Europe

### GBP/USD (Cable) 🇬🇧🇺🇸

**The Pound Sterling vs US Dollar**
- **Trading Volume:** ~13% of global FOREX volume
- **Key Drivers:** BoE policy, Fed policy, UK economic data, Brexit developments
- **Central Banks:** Bank of England (BoE) vs Federal Reserve (Fed)
- **Trading Hours:** Most liquid during London and US sessions
- **Typical Spread:** 0.5-2 pips
- **Volatility:** High

**Key Economic Indicators:**
- UK GDP, inflation, employment data
- BoE interest rate decisions
- US economic data
- Brexit-related news

**Trading Characteristics:**
- High volatility
- Larger price movements than EUR/USD
- Sensitive to UK political events
- Strong intraday trends

### USD/JPY (Dollar Yen) 🇺🇸🇯🇵

**The Dollar vs Japanese Yen**
- **Trading Volume:** ~17% of global FOREX volume
- **Key Drivers:** Fed policy, BoJ policy, risk sentiment, interest rate differentials
- **Central Banks:** Federal Reserve (Fed) vs Bank of Japan (BoJ)
- **Trading Hours:** Most liquid during Asian and US sessions
- **Typical Spread:** 0.1-0.5 pips
- **Volatility:** Moderate

**Key Economic Indicators:**
- US economic data
- BoJ policy decisions
- Japanese inflation and GDP
- Risk-on/risk-off sentiment

**Trading Characteristics:**
- Safe-haven currency (JPY)
- Responds to risk sentiment
- Carry trade favorite (when JPY rates are low)
- Smooth, trending moves

### USD/CHF (Swissy) 🇺🇸🇨🇭

**The Dollar vs Swiss Franc**
- **Trading Volume:** ~4% of global FOREX volume
- **Key Drivers:** Fed policy, SNB policy, risk sentiment, gold prices
- **Central Banks:** Federal Reserve (Fed) vs Swiss National Bank (SNB)
- **Trading Hours:** Most liquid during European and US sessions
- **Typical Spread:** 1-3 pips
- **Volatility:** Low to Moderate

**Key Economic Indicators:**
- US economic data
- SNB policy decisions
- Swiss inflation
- Gold prices (CHF correlation)

**Trading Characteristics:**
- CHF is a safe-haven currency
- Low volatility typically
- Moves opposite to EUR/USD often
- SNB occasionally intervenes

### AUD/USD (Aussie) 🇦🇺🇺🇸

**The Australian Dollar vs US Dollar**
- **Trading Volume:** ~5% of global FOREX volume
- **Key Drivers:** RBA policy, Fed policy, commodity prices, China economic data
- **Central Banks:** Reserve Bank of Australia (RBA) vs Federal Reserve (Fed)
- **Trading Hours:** Most liquid during Asian and US sessions
- **Typical Spread:** 0.5-1.5 pips
- **Volatility:** Moderate to High

**Key Economic Indicators:**
- Australian GDP, employment, inflation
- RBA interest rate decisions
- Commodity prices (iron ore, coal, gold)
- China economic data (major trade partner)

**Trading Characteristics:**
- Commodity currency
- Risk-on currency
- High correlation with gold and commodities
- Sensitive to China's economy

### USD/CAD (Loonie) 🇺🇸🇨🇦

**The Dollar vs Canadian Dollar**
- **Trading Volume:** ~4% of global FOREX volume
- **Key Drivers:** BoC policy, Fed policy, oil prices, US-Canada trade
- **Central Banks:** Federal Reserve (Fed) vs Bank of Canada (BoC)
- **Trading Hours:** Most liquid during US session
- **Typical Spread:** 1-2 pips
- **Volatility:** Moderate

**Key Economic Indicators:**
- Canadian GDP, employment, inflation
- BoC interest rate decisions
- Crude oil prices (major export)
- US economic data

**Trading Characteristics:**
- Commodity currency (oil)
- High correlation with crude oil
- Closely tied to US economy
- Lower volatility than other commodity currencies

### NZD/USD (Kiwi) 🇳🇿🇺🇸

**The New Zealand Dollar vs US Dollar**
- **Trading Volume:** ~2% of global FOREX volume
- **Key Drivers:** RBNZ policy, Fed policy, dairy prices, risk sentiment
- **Central Banks:** Reserve Bank of New Zealand (RBNZ) vs Federal Reserve (Fed)
- **Trading Hours:** Most liquid during Asian and US sessions
- **Typical Spread:** 1-3 pips
- **Volatility:** High

**Key Economic Indicators:**
- New Zealand GDP, inflation
- RBNZ interest rate decisions
- Dairy prices (major export)
- Australian economic data (correlation)

**Trading Characteristics:**
- Highest yielding major currency historically
- Commodity currency
- Carry trade favorite
- High volatility

## Market Hours

| Session | Trading Hours (UTC) | Active Pairs |
|---------|-------------------|--------------|
| Sydney | 22:00 - 07:00 | AUD/USD, NZD/USD |
| Tokyo | 00:00 - 09:00 | USD/JPY, AUD/USD, NZD/USD |
| London | 08:00 - 17:00 | EUR/USD, GBP/USD, USD/CHF |
| New York | 13:00 - 22:00 | All pairs |

**Best Trading Times:**
- **London-New York Overlap** (13:00-17:00 UTC): Highest liquidity for EUR/USD, GBP/USD
- **Tokyo-London Overlap** (08:00-09:00 UTC): Good for USD/JPY
- **Sydney-Tokyo Overlap** (00:00-07:00 UTC): Best for AUD/USD, NZD/USD

## Correlation Matrix

Understanding pair correlations helps in risk management:

| Pair | EUR/USD | GBP/USD | USD/JPY | AUD/USD | USD/CAD |
|------|---------|---------|---------|---------|---------|
| EUR/USD | 1.00 | 0.85 | -0.70 | 0.75 | -0.80 |
| GBP/USD | 0.85 | 1.00 | -0.60 | 0.70 | -0.75 |
| USD/JPY | -0.70 | -0.60 | 1.00 | -0.50 | 0.65 |
| AUD/USD | 0.75 | 0.70 | -0.50 | 1.00 | -0.80 |
| USD/CAD | -0.80 | -0.75 | 0.65 | -0.80 | 1.00 |

**Positive Correlation:** Pairs move in the same direction
**Negative Correlation:** Pairs move in opposite directions

## Pip Values

For standard lots (100,000 units):

| Pair | Pip Value (USD) |
|------|-----------------|
| EUR/USD | $10 |
| GBP/USD | $10 |
| USD/JPY | ~$9 (varies with rate) |
| USD/CHF | ~$10 (varies with rate) |
| AUD/USD | $10 |
| USD/CAD | ~$8 (varies with rate) |
| NZD/USD | $10 |

## Risk Factors

### EUR/USD
- ECB policy divergence from Fed
- Eurozone debt concerns
- Political instability in EU
- US economic surprises

### GBP/USD
- Brexit developments
- UK political instability
- BoE policy surprises
- Trade deal negotiations

### USD/JPY
- Risk-on/risk-off flows
- BoJ yield curve control
- Safe-haven demand
- Natural disasters in Japan

### AUD/USD
- China economic slowdown
- Commodity price crashes
- RBA policy surprises
- Trade war escalation

### USD/CAD
- Oil price volatility
- US-Canada trade tensions
- Canadian housing market
- NAFTA/USMCA changes

## Best Practices

1. **Trade during liquid hours** - Better spreads, less slippage
2. **Watch correlations** - Don't double up on similar positions
3. **Know your pair's drivers** - Each pair responds to different factors
4. **Respect volatility** - High volatility pairs need wider stops
5. **Follow central banks** - Policy drives long-term trends
6. **Check economic calendar** - Avoid surprises
7. **Understand carry trades** - Interest rate differentials matter

## Resources

- **Central Bank Websites:**
  - ECB: www.ecb.europa.eu
  - Fed: www.federalreserve.gov
  - BoE: www.bankofengland.co.uk
  - BoJ: www.boj.or.jp/en
  - SNB: www.snb.ch
  - RBA: www.rba.gov.au
  - BoC: www.bankofcanada.ca
  - RBNZ: www.rbnz.govt.nz

- **Economic Calendars:**
  - Forex Factory
  - Investing.com
  - DailyFX
  - Bloomberg

- **News Sources:**
  - Reuters
  - Bloomberg
  - Wall Street Journal
  - Financial Times
