---
name: yahoo-finance-forex
description: Fetches real-time FOREX news and market data from Yahoo Finance for major currency pairs (EUR/USD, GBP/USD, USD/JPY, etc.). Analyzes sentiment and provides trading context.
homepage: https://github.com/nazimboudeffa/openclaw-yahoo-finance-forex
metadata:
  openclaw:
    emoji: "💱"
    requires:
      bins: ["python3"]
    install:
      - id: pip
        kind: pip
        packages: ["yfinance>=0.2.40"]
        label: "Install yfinance"
---

# Yahoo Finance FOREX

Analyze major FOREX pairs using Yahoo Finance data: news, market data, sentiment analysis.

## When to Use This Skill

- User asks about FOREX pairs (EUR/USD, GBP/USD, USD/JPY, etc.)
- User wants latest FOREX news or market sentiment
- User needs fundamental analysis for currency trading
- User asks "What's happening with EUR/USD?" or similar

## Supported Currency Pairs

**7 Major Pairs:**
- EUR/USD 🇪🇺🇺🇸 (Euro Dollar)
- GBP/USD 🇬🇧🇺🇸 (Cable)
- USD/JPY 🇺🇸🇯🇵 (Dollar Yen)
- USD/CHF 🇺🇸🇨🇭 (Swissy)
- AUD/USD 🇦🇺🇺🇸 (Aussie)
- USD/CAD 🇺🇸🇨🇦 (Loonie)
- NZD/USD 🇳🇿🇺🇸 (Kiwi)

## Quick Start

### Fetch FOREX News

```bash
python3 scripts/fetch_forex_news.py EURUSD --limit 10
```

**Output:**
```json
{
  "pair": "EURUSD",
  "current_rate": 1.10250,
  "change_pct": 0.136,
  "news": [
    {
      "title": "ECB maintains hawkish stance on rates",
      "published": "2026-02-02 14:30:00",
      "publisher": "Reuters"
    }
  ],
  "sentiment": {
    "pair_sentiment": 3,
    "recommendation": "BUY"
  }
}
```

## Workflow

### 1. User Asks About FOREX

**User:** "What's happening with EUR/USD?"

**Your Action:**
1. Run: `python3 scripts/fetch_forex_news.py EURUSD --limit 8`
2. Parse the JSON output
3. Analyze the sentiment and news
4. Provide a summary with:
   - Current rate and change
   - Key news headlines
   - Sentiment analysis (bullish/bearish)
   - Trading context (support/resistance if available)

### 2. Analyze Sentiment

The script automatically calculates sentiment based on keywords:

**Bullish Keywords:** strengthens, rallies, hawkish, rate hike, growth
**Bearish Keywords:** weakens, falls, dovish, rate cut, recession

**Sentiment Score:**
- Positive (> 2): Bullish for the pair
- Negative (< -2): Bearish for the pair
- Near zero: Neutral

### 3. Provide Context

Always include:
- **Fundamentals:** What central banks are doing (ECB, Fed, BoJ, etc.)
- **News Impact:** How recent news affects the pair
- **Technical Context:** Current price vs support/resistance (if available)

## Script Reference

### fetch_forex_news.py

**Usage:**
```bash
python3 scripts/fetch_forex_news.py <PAIR> [--limit N]
```

**Arguments:**
- `<PAIR>`: Currency pair (EURUSD, GBPUSD, USDJPY, USDCHF, AUDUSD, USDCAD, NZDUSD)
- `--limit N`: Number of news articles to fetch (default: 10, max: 50)

**Output Fields:**
- `pair`: Currency pair code
- `current_rate`: Current exchange rate
- `change_pct`: 24h percentage change
- `news[]`: Array of news articles
  - `title`: Article headline
  - `published`: Publication timestamp
  - `publisher`: News source
  - `link`: Article URL (optional)
- `sentiment`: Sentiment analysis
  - `pair_sentiment`: Sentiment score (-10 to +10)
  - `recommendation`: BUY/SELL/HOLD

## Examples

### Get EUR/USD Analysis

```bash
python3 scripts/fetch_forex_news.py EURUSD --limit 5
```

### Get GBP/USD News

```bash
python3 scripts/fetch_forex_news.py GBPUSD --limit 8
```

## Central Bank Focus

When analyzing FOREX pairs, consider these central banks:
- **EUR/USD**: ECB (European Central Bank) vs Fed (Federal Reserve)
- **GBP/USD**: BoE (Bank of England) vs Fed
- **USD/JPY**: Fed vs BoJ (Bank of Japan)
- **USD/CHF**: Fed vs SNB (Swiss National Bank)
- **AUD/USD**: RBA (Reserve Bank of Australia) vs Fed
- **USD/CAD**: Fed vs BoC (Bank of Canada)
- **NZD/USD**: RBNZ (Reserve Bank of New Zealand) vs Fed

## Best Practices

1. **Always fetch news first** before making analysis
2. **Check sentiment score** to understand market bias
3. **Read headlines** to identify key drivers
4. **Consider fundamentals** (interest rates, economic data, geopolitics)
5. **Provide balanced analysis** - acknowledge both bullish and bearish factors
6. **Mention risk factors** - volatility, upcoming events, technical levels

## Reference Files

See `/references` directory for:
- `api-examples.md`: Detailed usage examples
- `forex-pairs.md`: Complete pairs reference with Yahoo Finance symbols
- `sentiment-guide.md`: Sentiment calculation methodology

## Limitations

- News data may have slight delays (1-5 minutes)
- Sentiment is keyword-based, not deep NLP analysis
- Historical data limited to recent news (last 7-14 days typically)
- No real-time tick data (only periodic updates)

## Troubleshooting

**Script fails to run:**
- Ensure Python 3.7+ is installed
- Install yfinance: `pip install yfinance>=0.2.40`

**No news returned:**
- Check internet connection
- Verify pair symbol is correct
- Try different pair or reduce limit

**Rate data missing:**
- Yahoo Finance API may be temporarily unavailable
- Try again in a few minutes

## Support

For issues or questions:
- GitHub: https://github.com/nazimboudeffa/openclaw-yahoo-finance-forex
- Report bugs via GitHub Issues
