---
name: xurl
description: A Twitter research and content intelligence skill focused on attracting WordPress and Shopify clients. Use to analyze Twitter profiles, threads, and conversations for: (1) Identifying what small agency founders and eCommerce brands are discussing; (2) Understanding pain points around WordPress performance, Shopify CRO, and development bottlenecks; (3) Extracting high-performing content angles; (4) Turning insights into authority-building posts; (5) Converting Twitter intelligence into business leverage for clear content angles, strong positioning, and qualified inbound leads.
---

# xurl: Twitter Content Intelligence for WordPress & Shopify

The `xurl` skill is designed to transform Twitter from passive scrolling into a powerful insight engine, authority builder, and lead radar, specifically tailored for engaging WordPress and Shopify clients. It goes beyond simple summaries to provide actionable intelligence for content creation, strategic positioning, and lead generation.

**Note:** `xurl` processes Twitter content that you provide (e.g., copied text of profiles, threads, or conversations, or URLs to pages containing such content). It does not directly access the Twitter API.

## Core Functions:

### 1. Twitter Profile Analysis
Analyze individual Twitter profiles to understand positioning, target audience, tone, content themes, and engagement patterns. Use this to craft effective conversation starters and tailor your outreach.
*For detailed guidance, refer to [references/twitter-profile-analysis.md](references/twitter-profile-analysis.md)*

### 2. Thread Breakdown
Deconstruct viral or high-performing Twitter threads. Extract the core idea, identify the hook structure, analyze the factors behind its success, and suggest improved or contrarian angles relevant to your niche.
*For detailed guidance, refer to [references/twitter-thread-breakdown.md](references/twitter-thread-breakdown.md)*

### 3. Pain Point Mining
Scan Twitter replies and discussions to identify recurring frustrations and challenges faced by small agency founders and eCommerce brands. Focus on common pain points related to WordPress performance, Shopify CRO, development bottlenecks, technical debt, and theme limitations.
*For detailed guidance, refer to [references/pain-point-mining.md](references/pain-point-mining.md)*

### 4. Content Opportunity Mapping
Generate actionable content ideas based on your Twitter research. This includes suggesting tweet ideas, contrarian takes, authority-building threads, and lead magnet concepts that resonate with your target audience.
*For detailed guidance, refer to [references/content-opportunity-mapping.md](references/content-opportunity-mapping.md)*

### 5. Lead Intelligence
Identify potential prospects by analyzing Twitter bios, hiring signals, growth-stage indicators, and website links in profiles. Convert these signals into qualified inbound lead opportunities.
*For detailed guidance, refer to [references/lead-intelligence-signals.md](references/lead-intelligence-signals.md)*
