---
name: xpoz-social-search
description: "Search Twitter, Instagram, and Reddit posts in real time. Find social media mentions, track hashtags, discover influencers, and analyze engagement — 1.5B+ posts indexed. Social listening, brand monitoring, and competitor research made easy for AI agents."
homepage: https://xpoz.ai
metadata:
  {
    "openclaw":
      {
        "requires": { "bins": ["mcporter"], "skills": ["xpoz-setup"], "network": ["mcp.xpoz.ai"], "credentials": "Xpoz account (free tier) — auth via xpoz-setup skill (OAuth 2.1)" },
        "install": [{"id": "node", "kind": "node", "package": "mcporter", "bins": ["mcporter"], "label": "Install mcporter (npm)"}],
      },
  }
tags:
  - social-media
  - search
  - twitter
  - instagram
  - reddit
  - mcp
  - xpoz
  - research
  - intelligence
  - discovery
  - social-search
  - twitter-search
  - social-listening
  - brand-monitoring
  - hashtag
  - mentions
  - influencer
  - engagement
  - viral
  - trending
---

# Xpoz Social Search

**Multi-platform social search: 1.5B+ posts across Twitter, Instagram, Reddit.**

Search posts, find people, discover conversations. Built on Xpoz MCP.

## Setup

Run `xpoz-setup` skill. Verify: `mcporter call xpoz.checkAccessKeyStatus`

## Tool Reference

| Tool | Platform | Purpose |
|------|----------|---------|
| `getTwitterPostsByKeywords` | Twitter | Search tweets |
| `getInstagramPostsByKeywords` | Instagram | Search posts |
| `getRedditPostsByKeywords` | Reddit | Search posts |
| `getTwitterUsersByKeywords` | Twitter | Find users |
| `getInstagramUsersByKeywords` | Instagram | Find users |
| `getRedditUsersByKeywords` | Reddit | Find users |
| `getTwitterUser` | Twitter | Profile by username/id |
| `getInstagramUser` | Instagram | Profile by username/id |
| `getRedditUser` | Reddit | Profile by username |
| `searchTwitterUsers` | Twitter | Search by name |
| `checkOperationStatus` | — | **Poll for results** |
| `getRedditSubredditsByKeywords` | Reddit | Find subreddits |

**Params:** `query`, `startDate`/`endDate` (YYYY-MM-DD), `limit`, `fields`

## Patterns

**Search posts:**
```bash
mcporter call xpoz.getTwitterPostsByKeywords query="MCP" startDate=2026-01-01
mcporter call xpoz.checkOperationStatus operationId=op_abc # Poll every 5s
```

**Find people:**
```bash
mcporter call xpoz.getTwitterUsersByKeywords query='"open source" AND LLM'
```

**Profile:**
```bash
mcporter call xpoz.getTwitterUser identifier=elonmusk identifierType=username
```

**Boolean:** `AND`, `OR`, `NOT`, `"exact"`, `()`
```bash
query="Tesla AND cars NOT stock"
```

**CSV export:** Use `dataDumpExportOperationId` from search, poll for URL (up to 64K rows).

## Examples

**Competitive intel:**
```bash
mcporter call xpoz.getTwitterPostsByKeywords query="CompetitorName"
mcporter call xpoz.getTwitterUsersByKeywords query="CompetitorName"
```

**Influencers:**
```bash
mcporter call xpoz.getInstagramUsersByKeywords query="fitness transformation"
```

**Communities:**
```bash
mcporter call xpoz.getRedditSubredditsByKeywords query="startup"
```

## Notes

⚠️ **Always poll** `checkOperationStatus` — searches return `operationId`, not data  
🚀 **Use `fields`** for performance  
📊 **CSV for scale** via `dataDumpExportOperationId`  
📅 **Dates:** `YYYY-MM-DD` (current: 2026)

**Free tier:** 100 searches/mo, 1K results/search | [xpoz.ai](https://xpoz.ai)
