# XLSX Pro

![Version](https://img.shields.io/badge/version-1.0.1-blue) ![License](https://img.shields.io/badge/license-MIT-green)

Un skill **Clawdbot / OpenClawd** pour générer et modifier des fichiers Excel **propres** (XLSX / XLSM / CSV / TSV) avec :
- formatage “pro”
- **formules Excel** (au lieu de valeurs hardcodées)
- recalcul optionnel des formules via **LibreOffice headless**
- contrôle qualité : détection des erreurs Excel (`#REF!`, `#DIV/0!`, `#VALUE!`, `#N/A`, `#NAME?`, …)

## Pourquoi ce skill ?

`openpyxl` sait **écrire** des formules, mais ne sait pas **calculer** leurs résultats. En production, ça crée des fichiers où les formules ne sont pas évaluées et où les erreurs ne sont pas détectées.

`XLSX Pro` ajoute une étape serveur fiable : **recalcul via LibreOffice** + scan d’erreurs.

## Prérequis

### Python
```bash
pip install openpyxl pandas xlrd xlwt
```

### LibreOffice (uniquement si tu veux recalculer les formules)
Ubuntu/Debian :
```bash
sudo apt-get update
sudo apt-get install -y libreoffice-calc libreoffice-common
```

## Quickstart

### 1) Générer un fichier Excel (avec openpyxl)
Tu peux créer ton `.xlsx` comme d’habitude en Python, en mettant des **formules** dans les cellules.

### 2) Recalculer + valider
```bash
python scripts/recalc.py ton_fichier.xlsx 60
```

Sortie JSON :
- `status: success | errors_found`
- `total_errors`
- `error_summary` (types + emplacements)
- `total_formulas`

## Bonnes pratiques (résumé)
- **Préférer les formules Excel** plutôt que calculer en Python puis écrire des valeurs.
- **Zéro erreur de formule** dans le livrable.
- Si tu modifies un template existant : **respecte exactement** les styles/conventions.

## Troubleshooting
- Si `soffice` est introuvable : installe LibreOffice (voir Prérequis).
- Si le recalcul “timeout” : augmente le timeout (2e argument) et/ou teste sur un fichier plus petit.
- Si erreur du type "macro mal configurée" / "macro not configured" : supprime le fichier de macro puis relance :
  - Linux : `~/.config/libreoffice/4/user/basic/Standard/Module1.xba`
  - macOS : `~/Library/Application Support/LibreOffice/4/user/basic/Standard/Module1.xba`
- En conteneur (Docker) : ajoute la variable d'env `SAL_USE_VCLPLUGIN=svp` (ça évite des soucis d'UI en headless).

## Licence
MIT (à ajuster si tu veux une autre licence).
