# Security Scan Delta: `2026.2.20.2` vs `2026.2.19-3`

Date: 2026-02-21

## Scope
- Skill: `xint`
- Comparison: `2026.2.20-2` vs `2026.2.19-3` on ClawHub
- VirusTotal check target: SHA256 `5e39443786746cd05fa1fe85947003116870d43e58ed9e6e6b871ece580c26ab` (`xint-rs` macOS arm64 release tarball)

## Evidence Collected
- ClawHub search confirms current publish versions:
  - `xint v2026.2.20-2`
  - `xint-rs v2026.2.20-2`
- ClawHub API (`/api/v1/skills/xint`) reports latest version `2026.2.20-2`.
- ClawHub API (`/api/v1/skills/xint?include=moderation`) returns `moderation: null`.
- ClawHub API version payloads:
  - `xint 2026.2.19-3`: 55 files
  - `xint 2026.2.20-2`: 72 files
- VirusTotal public API request without key returns:
  - HTTP `401`
  - `AuthenticationRequiredError` (`X-Apikey header is missing`)

## Delta Assessment
- Distribution/version delta is confirmed (`2026.2.20-2` is live and discoverable).
- A machine-readable moderation/verdict delta is **not available** from public ClawHub endpoints (moderation field currently null).
- VirusTotal verdict delta is **not available** without a VT API key (or manual UI evidence export).

## What Changed That Should Improve Scanner Posture
- Security-oriented wording hardening in `SKILL.md` files (`xint`, `xint-rs`, packaged skill docs).
- Weak auth placeholder removed from MCP examples.
- Runtime scope wording clarified to reduce prompt-injection style false-positive triggers.

## Next Verification Actions
1. Pull OpenClaw moderation/verdict from authenticated UI/API and append to this report.
2. Re-run VirusTotal with API key and capture detection ratio snapshot for `2026.2.20.2` artifacts.
3. Publish an updated delta section with explicit `before -> after` verdicts once both sources are available.
